<?php

require 'vendor/autoload.php';

use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\OAuth;
use AmazonPHP\SellingPartner\Regions;
use AmazonPHP\SellingPartner\SellingPartnerSDK;
use GuzzleHttp\Client as GuzzleClient;
use Nyholm\Psr7\Factory\Psr17Factory;
use Psr\Log\NullLogger;
use AmazonPHP\SellingPartner\Model\Notifications\CreateDestinationRequest;
use AmazonPHP\SellingPartner\Model\Notifications\DestinationResourceSpecification;

// config
$config = require_once __DIR__ . '/config.php';

// SDK Setup
$factory = new Psr17Factory();
$client = new GuzzleClient();
$httpFactory = new HttpFactory($factory, $factory);
$logger = new NullLogger();

$oauth = new OAuth(
    $client,
    $httpFactory,
    $configuration = Configuration::forIAMUser(
        $config['lwa_client_id'],
        $config['lwa_client_secret'],
        $config['aws_access_key'],
        $config['aws_secret_key']
    ),
    $logger // Add the logger as the 4th parameter
);
$accessToken = $oauth->exchangeRefreshToken($config['refresh_token']);

$sdk = SellingPartnerSDK::create(
    $client,
    $factory,
    $factory,
    $configuration,
    $logger
);

$region = Regions::NORTH_AMERICA;

$httpEndpoint = 'https://apps1.infoshore.biz/updateaac/laravel/public/checkingAmazonNotification.php';

// Create a stdClass with the required 'endpoint' field
$http = new \stdClass();
$http->endpoint = $httpEndpoint;

// Now build the resource spec with stdClass as http
$resourceSpec = new DestinationResourceSpecification([
    'http' => $http,
    'sqs' => null,
    'eventBridge' => null,
]);

print_r($resourceSpec);

echo "tarunnnnnnnnnnnnnnnnnnnnnnnnnn 1";

$destinationRequest = new CreateDestinationRequest([
    'name' => 'MyDestinationName',
    'resourceSpecification' => $resourceSpec,
]);
print_r($destinationRequest);
echo "tarunnnnnnnnnnnnnnnnnnnnnnnnnn 2";

// Create destination
$response = $sdk->notifications()->createDestination(
    $accessToken,
    $region,
    $destinationRequest
);

echo 'Destination ID: ' . $response->getPayload()->getDestinationId();
