<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\FbaInboundApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Configuration;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;
use AmazonPHP\SellingPartner\HttpFactory;
use AmazonPHP\SellingPartner\HttpSignatureHeaders;
use AmazonPHP\SellingPartner\ObjectSerializer;
use Psr\Http\Client\ClientExceptionInterface;
use Psr\Http\Client\ClientInterface;
use Psr\Http\Message\RequestInterface;
use Psr\Log\LoggerInterface;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
final class FulfillmentInboundSDK implements FulfillmentInboundSDKInterface
{
    public function __construct(private readonly ClientInterface $client, private readonly HttpFactory $httpFactory, private readonly Configuration $configuration, private readonly LoggerInterface $logger)
    {
    }

    /**
     * Operation cancelInboundPlan.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function cancelInboundPlan(AccessToken $accessToken, string $region, string $inbound_plan_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelInboundPlanResponse
    {
        $request = $this->cancelInboundPlanRequest($accessToken, $region, $inbound_plan_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'cancelInboundPlan', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'cancelInboundPlan')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'cancelInboundPlan'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'cancelInboundPlan',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'cancelInboundPlan', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'cancelInboundPlan')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'cancelInboundPlan'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'cancelInboundPlan',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelInboundPlanResponse',
            []
        );
    }

    /**
     * Create request for operation 'cancelInboundPlan'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws InvalidArgumentException
     */
    public function cancelInboundPlanRequest(AccessToken $accessToken, string $region, string $inbound_plan_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling cancelInboundPlan'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.cancelInboundPlan, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.cancelInboundPlan, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.cancelInboundPlan, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/cancellation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation cancelSelfShipAppointment.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentRequest $body The body of the request to &#x60;cancelSelfShipAppointment&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function cancelSelfShipAppointment(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentResponse
    {
        $request = $this->cancelSelfShipAppointmentRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'cancelSelfShipAppointment', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'cancelSelfShipAppointment')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'cancelSelfShipAppointment'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'cancelSelfShipAppointment',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'cancelSelfShipAppointment', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'cancelSelfShipAppointment')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'cancelSelfShipAppointment'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'cancelSelfShipAppointment',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentResponse',
            []
        );
    }

    /**
     * Create request for operation 'cancelSelfShipAppointment'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentRequest $body The body of the request to &#x60;cancelSelfShipAppointment&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function cancelSelfShipAppointmentRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CancelSelfShipAppointmentRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling cancelSelfShipAppointment'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.cancelSelfShipAppointment, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.cancelSelfShipAppointment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.cancelSelfShipAppointment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling cancelSelfShipAppointment'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.cancelSelfShipAppointment, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.cancelSelfShipAppointment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.cancelSelfShipAppointment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling cancelSelfShipAppointment'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentCancellation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation confirmDeliveryWindowOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to confirm the delivery window option for. (required)
     * @param string $delivery_window_option_id The id of the delivery window option to be confirmed. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmDeliveryWindowOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $delivery_window_option_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmDeliveryWindowOptionsResponse
    {
        $request = $this->confirmDeliveryWindowOptionsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $delivery_window_option_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'confirmDeliveryWindowOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmDeliveryWindowOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmDeliveryWindowOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmDeliveryWindowOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'confirmDeliveryWindowOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmDeliveryWindowOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmDeliveryWindowOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmDeliveryWindowOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmDeliveryWindowOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'confirmDeliveryWindowOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to confirm the delivery window option for. (required)
     * @param string $delivery_window_option_id The id of the delivery window option to be confirmed. (required)
     *
     * @throws InvalidArgumentException
     */
    public function confirmDeliveryWindowOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $delivery_window_option_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling confirmDeliveryWindowOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling confirmDeliveryWindowOptions'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'delivery_window_option_id' is set
        if ($delivery_window_option_id === null || (\is_array($delivery_window_option_id) && \count($delivery_window_option_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $delivery_window_option_id when calling confirmDeliveryWindowOptions'
            );
        }

        if (\strlen($delivery_window_option_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$delivery_window_option_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($delivery_window_option_id) < 36) {
            throw new InvalidArgumentException('invalid length for "$delivery_window_option_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must be bigger than or equal to 36.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $delivery_window_option_id)) {
            throw new InvalidArgumentException('invalid value for "delivery_window_option_id" when calling FbaInboundApi.confirmDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryWindowOptions/{deliveryWindowOptionId}/confirmation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        // path params
        if ($delivery_window_option_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'deliveryWindowOptionId' . '}',
                ObjectSerializer::toPathValue($delivery_window_option_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation confirmPackingOption.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_option_id Identifier of a packing option. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmPackingOption(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_option_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmPackingOptionResponse
    {
        $request = $this->confirmPackingOptionRequest($accessToken, $region, $inbound_plan_id, $packing_option_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'confirmPackingOption', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmPackingOption')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmPackingOption'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmPackingOption',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'confirmPackingOption', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmPackingOption')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmPackingOption'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmPackingOption',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmPackingOptionResponse',
            []
        );
    }

    /**
     * Create request for operation 'confirmPackingOption'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_option_id Identifier of a packing option. (required)
     *
     * @throws InvalidArgumentException
     */
    public function confirmPackingOptionRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_option_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling confirmPackingOption'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmPackingOption, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmPackingOption, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.confirmPackingOption, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'packing_option_id' is set
        if ($packing_option_id === null || (\is_array($packing_option_id) && \count($packing_option_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $packing_option_id when calling confirmPackingOption'
            );
        }

        if (\strlen($packing_option_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$packing_option_id" when calling FbaInboundApi.confirmPackingOption, must be smaller than or equal to 38.');
        }

        if (\strlen($packing_option_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$packing_option_id" when calling FbaInboundApi.confirmPackingOption, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $packing_option_id)) {
            throw new InvalidArgumentException('invalid value for "packing_option_id" when calling FbaInboundApi.confirmPackingOption, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingOptions/{packingOptionId}/confirmation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($packing_option_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'packingOptionId' . '}',
                ObjectSerializer::toPathValue($packing_option_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation confirmPlacementOption.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $placement_option_id The identifier of a placement option. A placement option represents the shipment splits and destinations of SKUs. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmPlacementOption(AccessToken $accessToken, string $region, string $inbound_plan_id, string $placement_option_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmPlacementOptionResponse
    {
        $request = $this->confirmPlacementOptionRequest($accessToken, $region, $inbound_plan_id, $placement_option_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'confirmPlacementOption', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmPlacementOption')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmPlacementOption'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmPlacementOption',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'confirmPlacementOption', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmPlacementOption')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmPlacementOption'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmPlacementOption',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmPlacementOptionResponse',
            []
        );
    }

    /**
     * Create request for operation 'confirmPlacementOption'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $placement_option_id The identifier of a placement option. A placement option represents the shipment splits and destinations of SKUs. (required)
     *
     * @throws InvalidArgumentException
     */
    public function confirmPlacementOptionRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $placement_option_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling confirmPlacementOption'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmPlacementOption, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmPlacementOption, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.confirmPlacementOption, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'placement_option_id' is set
        if ($placement_option_id === null || (\is_array($placement_option_id) && \count($placement_option_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $placement_option_id when calling confirmPlacementOption'
            );
        }

        if (\strlen($placement_option_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$placement_option_id" when calling FbaInboundApi.confirmPlacementOption, must be smaller than or equal to 38.');
        }

        if (\strlen($placement_option_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$placement_option_id" when calling FbaInboundApi.confirmPlacementOption, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $placement_option_id)) {
            throw new InvalidArgumentException('invalid value for "placement_option_id" when calling FbaInboundApi.confirmPlacementOption, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/placementOptions/{placementOptionId}/confirmation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($placement_option_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'placementOptionId' . '}',
                ObjectSerializer::toPathValue($placement_option_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation confirmShipmentContentUpdatePreview.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $content_update_preview_id Identifier of a content update preview. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmShipmentContentUpdatePreview(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $content_update_preview_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmShipmentContentUpdatePreviewResponse
    {
        $request = $this->confirmShipmentContentUpdatePreviewRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $content_update_preview_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'confirmShipmentContentUpdatePreview', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmShipmentContentUpdatePreview')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmShipmentContentUpdatePreview'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmShipmentContentUpdatePreview',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'confirmShipmentContentUpdatePreview', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmShipmentContentUpdatePreview')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmShipmentContentUpdatePreview'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmShipmentContentUpdatePreview',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmShipmentContentUpdatePreviewResponse',
            []
        );
    }

    /**
     * Create request for operation 'confirmShipmentContentUpdatePreview'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $content_update_preview_id Identifier of a content update preview. (required)
     *
     * @throws InvalidArgumentException
     */
    public function confirmShipmentContentUpdatePreviewRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $content_update_preview_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling confirmShipmentContentUpdatePreview'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling confirmShipmentContentUpdatePreview'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'content_update_preview_id' is set
        if ($content_update_preview_id === null || (\is_array($content_update_preview_id) && \count($content_update_preview_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $content_update_preview_id when calling confirmShipmentContentUpdatePreview'
            );
        }

        if (\strlen($content_update_preview_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$content_update_preview_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must be smaller than or equal to 38.');
        }

        if (\strlen($content_update_preview_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$content_update_preview_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $content_update_preview_id)) {
            throw new InvalidArgumentException('invalid value for "content_update_preview_id" when calling FbaInboundApi.confirmShipmentContentUpdatePreview, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews/{contentUpdatePreviewId}/confirmation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        // path params
        if ($content_update_preview_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'contentUpdatePreviewId' . '}',
                ObjectSerializer::toPathValue($content_update_preview_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation confirmTransportationOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsRequest $body The body of the request to &#x60;confirmTransportationOptions&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function confirmTransportationOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsResponse
    {
        $request = $this->confirmTransportationOptionsRequest($accessToken, $region, $inbound_plan_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'confirmTransportationOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmTransportationOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmTransportationOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmTransportationOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'confirmTransportationOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'confirmTransportationOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'confirmTransportationOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'confirmTransportationOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'confirmTransportationOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsRequest $body The body of the request to &#x60;confirmTransportationOptions&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function confirmTransportationOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ConfirmTransportationOptionsRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling confirmTransportationOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmTransportationOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.confirmTransportationOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.confirmTransportationOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling confirmTransportationOptions'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/transportationOptions/confirmation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation createInboundPlan.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanRequest $body The body of the request to &#x60;createInboundPlan&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function createInboundPlan(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanResponse
    {
        $request = $this->createInboundPlanRequest($accessToken, $region, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'createInboundPlan', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'createInboundPlan')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'createInboundPlan'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'createInboundPlan',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'createInboundPlan', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'createInboundPlan')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'createInboundPlan'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'createInboundPlan',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanResponse',
            []
        );
    }

    /**
     * Create request for operation 'createInboundPlan'.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanRequest $body The body of the request to &#x60;createInboundPlan&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function createInboundPlanRequest(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateInboundPlanRequest $body) : RequestInterface
    {
        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling createInboundPlan'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation createMarketplaceItemLabels.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsRequest $body The body of the request to &#x60;createMarketplaceItemLabels&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function createMarketplaceItemLabels(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsResponse
    {
        $request = $this->createMarketplaceItemLabelsRequest($accessToken, $region, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'createMarketplaceItemLabels', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'createMarketplaceItemLabels')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'createMarketplaceItemLabels'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'createMarketplaceItemLabels',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'createMarketplaceItemLabels', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'createMarketplaceItemLabels')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'createMarketplaceItemLabels'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'createMarketplaceItemLabels',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsResponse',
            []
        );
    }

    /**
     * Create request for operation 'createMarketplaceItemLabels'.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsRequest $body The body of the request to &#x60;createMarketplaceItemLabels&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function createMarketplaceItemLabelsRequest(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\CreateMarketplaceItemLabelsRequest $body) : RequestInterface
    {
        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling createMarketplaceItemLabels'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/items/labels';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation generateDeliveryWindowOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to generate delivery window options for. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateDeliveryWindowOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateDeliveryWindowOptionsResponse
    {
        $request = $this->generateDeliveryWindowOptionsRequest($accessToken, $region, $inbound_plan_id, $shipment_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'generateDeliveryWindowOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateDeliveryWindowOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateDeliveryWindowOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateDeliveryWindowOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'generateDeliveryWindowOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateDeliveryWindowOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateDeliveryWindowOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateDeliveryWindowOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateDeliveryWindowOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'generateDeliveryWindowOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to generate delivery window options for. (required)
     *
     * @throws InvalidArgumentException
     */
    public function generateDeliveryWindowOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling generateDeliveryWindowOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateDeliveryWindowOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.generateDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling generateDeliveryWindowOptions'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.generateDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.generateDeliveryWindowOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.generateDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryWindowOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation generatePackingOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generatePackingOptions(AccessToken $accessToken, string $region, string $inbound_plan_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePackingOptionsResponse
    {
        $request = $this->generatePackingOptionsRequest($accessToken, $region, $inbound_plan_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'generatePackingOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generatePackingOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generatePackingOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generatePackingOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'generatePackingOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generatePackingOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generatePackingOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generatePackingOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePackingOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'generatePackingOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws InvalidArgumentException
     */
    public function generatePackingOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling generatePackingOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generatePackingOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generatePackingOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.generatePackingOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation generatePlacementOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsRequest $body The body of the request to &#x60;generatePlacementOptions&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generatePlacementOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsResponse
    {
        $request = $this->generatePlacementOptionsRequest($accessToken, $region, $inbound_plan_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'generatePlacementOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generatePlacementOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generatePlacementOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generatePlacementOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'generatePlacementOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generatePlacementOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generatePlacementOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generatePlacementOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'generatePlacementOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsRequest $body The body of the request to &#x60;generatePlacementOptions&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function generatePlacementOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GeneratePlacementOptionsRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling generatePlacementOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generatePlacementOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generatePlacementOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.generatePlacementOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling generatePlacementOptions'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/placementOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation generateSelfShipAppointmentSlots.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsRequest $body The body of the request to &#x60;generateSelfShipAppointmentSlots&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateSelfShipAppointmentSlots(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsResponse
    {
        $request = $this->generateSelfShipAppointmentSlotsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'generateSelfShipAppointmentSlots', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateSelfShipAppointmentSlots')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateSelfShipAppointmentSlots'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateSelfShipAppointmentSlots',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'generateSelfShipAppointmentSlots', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateSelfShipAppointmentSlots')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateSelfShipAppointmentSlots'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateSelfShipAppointmentSlots',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsResponse',
            []
        );
    }

    /**
     * Create request for operation 'generateSelfShipAppointmentSlots'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsRequest $body The body of the request to &#x60;generateSelfShipAppointmentSlots&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function generateSelfShipAppointmentSlotsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateSelfShipAppointmentSlotsRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling generateSelfShipAppointmentSlots'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateSelfShipAppointmentSlots, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateSelfShipAppointmentSlots, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.generateSelfShipAppointmentSlots, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling generateSelfShipAppointmentSlots'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.generateSelfShipAppointmentSlots, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.generateSelfShipAppointmentSlots, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.generateSelfShipAppointmentSlots, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling generateSelfShipAppointmentSlots'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentSlots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation generateShipmentContentUpdatePreviews.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsRequest $body The body of the request to &#x60;generateShipmentContentUpdatePreviews&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateShipmentContentUpdatePreviews(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsResponse
    {
        $request = $this->generateShipmentContentUpdatePreviewsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'generateShipmentContentUpdatePreviews', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateShipmentContentUpdatePreviews')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateShipmentContentUpdatePreviews'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateShipmentContentUpdatePreviews',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'generateShipmentContentUpdatePreviews', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateShipmentContentUpdatePreviews')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateShipmentContentUpdatePreviews'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateShipmentContentUpdatePreviews',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsResponse',
            []
        );
    }

    /**
     * Create request for operation 'generateShipmentContentUpdatePreviews'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsRequest $body The body of the request to &#x60;generateShipmentContentUpdatePreviews&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function generateShipmentContentUpdatePreviewsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateShipmentContentUpdatePreviewsRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling generateShipmentContentUpdatePreviews'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateShipmentContentUpdatePreviews, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateShipmentContentUpdatePreviews, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.generateShipmentContentUpdatePreviews, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling generateShipmentContentUpdatePreviews'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.generateShipmentContentUpdatePreviews, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.generateShipmentContentUpdatePreviews, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.generateShipmentContentUpdatePreviews, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling generateShipmentContentUpdatePreviews'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation generateTransportationOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsRequest $body The body of the request to &#x60;generateTransportationOptions&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function generateTransportationOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsResponse
    {
        $request = $this->generateTransportationOptionsRequest($accessToken, $region, $inbound_plan_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'generateTransportationOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateTransportationOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateTransportationOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateTransportationOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'generateTransportationOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'generateTransportationOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'generateTransportationOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'generateTransportationOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'generateTransportationOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsRequest $body The body of the request to &#x60;generateTransportationOptions&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function generateTransportationOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GenerateTransportationOptionsRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling generateTransportationOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateTransportationOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.generateTransportationOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.generateTransportationOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling generateTransportationOptions'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/transportationOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getDeliveryChallanDocument.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getDeliveryChallanDocument(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GetDeliveryChallanDocumentResponse
    {
        $request = $this->getDeliveryChallanDocumentRequest($accessToken, $region, $inbound_plan_id, $shipment_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'getDeliveryChallanDocument', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getDeliveryChallanDocument')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getDeliveryChallanDocument'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getDeliveryChallanDocument',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'getDeliveryChallanDocument', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getDeliveryChallanDocument')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getDeliveryChallanDocument'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getDeliveryChallanDocument',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GetDeliveryChallanDocumentResponse',
            []
        );
    }

    /**
     * Create request for operation 'getDeliveryChallanDocument'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     *
     * @throws InvalidArgumentException
     */
    public function getDeliveryChallanDocumentRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling getDeliveryChallanDocument'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getDeliveryChallanDocument, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getDeliveryChallanDocument, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.getDeliveryChallanDocument, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling getDeliveryChallanDocument'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getDeliveryChallanDocument, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getDeliveryChallanDocument, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.getDeliveryChallanDocument, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryChallanDocument';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getInboundOperationStatus.
     *
     * @param string $operation_id Identifier of an asynchronous operation. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getInboundOperationStatus(AccessToken $accessToken, string $region, string $operation_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\InboundOperationStatus
    {
        $request = $this->getInboundOperationStatusRequest($accessToken, $region, $operation_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'getInboundOperationStatus', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getInboundOperationStatus')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getInboundOperationStatus'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getInboundOperationStatus',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'getInboundOperationStatus', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getInboundOperationStatus')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getInboundOperationStatus'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getInboundOperationStatus',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\InboundOperationStatus',
            []
        );
    }

    /**
     * Create request for operation 'getInboundOperationStatus'.
     *
     * @param string $operation_id Identifier of an asynchronous operation. (required)
     *
     * @throws InvalidArgumentException
     */
    public function getInboundOperationStatusRequest(AccessToken $accessToken, string $region, string $operation_id) : RequestInterface
    {
        // verify the required parameter 'operation_id' is set
        if ($operation_id === null || (\is_array($operation_id) && \count($operation_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $operation_id when calling getInboundOperationStatus'
            );
        }

        if (\strlen($operation_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$operation_id" when calling FbaInboundApi.getInboundOperationStatus, must be smaller than or equal to 38.');
        }

        if (\strlen($operation_id) < 36) {
            throw new InvalidArgumentException('invalid length for "$operation_id" when calling FbaInboundApi.getInboundOperationStatus, must be bigger than or equal to 36.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $operation_id)) {
            throw new InvalidArgumentException('invalid value for "operation_id" when calling FbaInboundApi.getInboundOperationStatus, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/operations/{operationId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($operation_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'operationId' . '}',
                ObjectSerializer::toPathValue($operation_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getInboundPlan.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getInboundPlan(AccessToken $accessToken, string $region, string $inbound_plan_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\InboundPlan
    {
        $request = $this->getInboundPlanRequest($accessToken, $region, $inbound_plan_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'getInboundPlan', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getInboundPlan')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getInboundPlan'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getInboundPlan',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'getInboundPlan', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getInboundPlan')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getInboundPlan'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getInboundPlan',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\InboundPlan',
            []
        );
    }

    /**
     * Create request for operation 'getInboundPlan'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     *
     * @throws InvalidArgumentException
     */
    public function getInboundPlanRequest(AccessToken $accessToken, string $region, string $inbound_plan_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling getInboundPlan'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getInboundPlan, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getInboundPlan, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.getInboundPlan, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getSelfShipAppointmentSlots.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of self ship appointment slots to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getSelfShipAppointmentSlots(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\GetSelfShipAppointmentSlotsResponse
    {
        $request = $this->getSelfShipAppointmentSlotsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'getSelfShipAppointmentSlots', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getSelfShipAppointmentSlots')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getSelfShipAppointmentSlots'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getSelfShipAppointmentSlots',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'getSelfShipAppointmentSlots', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getSelfShipAppointmentSlots')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getSelfShipAppointmentSlots'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getSelfShipAppointmentSlots',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\GetSelfShipAppointmentSlotsResponse',
            []
        );
    }

    /**
     * Create request for operation 'getSelfShipAppointmentSlots'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of self ship appointment slots to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function getSelfShipAppointmentSlotsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling getSelfShipAppointmentSlots'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.getSelfShipAppointmentSlots, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling getSelfShipAppointmentSlots'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.getSelfShipAppointmentSlots, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 100) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be smaller than or equal to 100.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.getSelfShipAppointmentSlots, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentSlots';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getShipment.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getShipment(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\Shipment
    {
        $request = $this->getShipmentRequest($accessToken, $region, $inbound_plan_id, $shipment_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'getShipment', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getShipment')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getShipment'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getShipment',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'getShipment', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getShipment')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getShipment'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getShipment',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\Shipment',
            []
        );
    }

    /**
     * Create request for operation 'getShipment'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     *
     * @throws InvalidArgumentException
     */
    public function getShipmentRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling getShipment'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getShipment, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getShipment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.getShipment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling getShipment'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getShipment, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getShipment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.getShipment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation getShipmentContentUpdatePreview.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $content_update_preview_id Identifier of a content update preview. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getShipmentContentUpdatePreview(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $content_update_preview_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ContentUpdatePreview
    {
        $request = $this->getShipmentContentUpdatePreviewRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $content_update_preview_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'getShipmentContentUpdatePreview', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getShipmentContentUpdatePreview')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getShipmentContentUpdatePreview'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getShipmentContentUpdatePreview',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'getShipmentContentUpdatePreview', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'getShipmentContentUpdatePreview')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'getShipmentContentUpdatePreview'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'getShipmentContentUpdatePreview',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ContentUpdatePreview',
            []
        );
    }

    /**
     * Create request for operation 'getShipmentContentUpdatePreview'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $content_update_preview_id Identifier of a content update preview. (required)
     *
     * @throws InvalidArgumentException
     */
    public function getShipmentContentUpdatePreviewRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $content_update_preview_id) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling getShipmentContentUpdatePreview'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling getShipmentContentUpdatePreview'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'content_update_preview_id' is set
        if ($content_update_preview_id === null || (\is_array($content_update_preview_id) && \count($content_update_preview_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $content_update_preview_id when calling getShipmentContentUpdatePreview'
            );
        }

        if (\strlen($content_update_preview_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$content_update_preview_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must be smaller than or equal to 38.');
        }

        if (\strlen($content_update_preview_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$content_update_preview_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $content_update_preview_id)) {
            throw new InvalidArgumentException('invalid value for "content_update_preview_id" when calling FbaInboundApi.getShipmentContentUpdatePreview, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews/{contentUpdatePreviewId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        // path params
        if ($content_update_preview_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'contentUpdatePreviewId' . '}',
                ObjectSerializer::toPathValue($content_update_preview_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listDeliveryWindowOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to get delivery window options for. (required)
     * @param null|int $page_size The number of delivery window options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listDeliveryWindowOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListDeliveryWindowOptionsResponse
    {
        $request = $this->listDeliveryWindowOptionsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listDeliveryWindowOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listDeliveryWindowOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listDeliveryWindowOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listDeliveryWindowOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listDeliveryWindowOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listDeliveryWindowOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listDeliveryWindowOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listDeliveryWindowOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListDeliveryWindowOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listDeliveryWindowOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id The shipment to get delivery window options for. (required)
     * @param null|int $page_size The number of delivery window options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listDeliveryWindowOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listDeliveryWindowOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listDeliveryWindowOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling listDeliveryWindowOptions'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listDeliveryWindowOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listDeliveryWindowOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.listDeliveryWindowOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 100) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listDeliveryWindowOptions, must be smaller than or equal to 100.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listDeliveryWindowOptions, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listDeliveryWindowOptions, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listDeliveryWindowOptions, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/deliveryWindowOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listInboundPlanBoxes.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlanBoxes(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanBoxesResponse
    {
        $request = $this->listInboundPlanBoxesRequest($accessToken, $region, $inbound_plan_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listInboundPlanBoxes', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlanBoxes')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlanBoxes'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlanBoxes',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listInboundPlanBoxes', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlanBoxes')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlanBoxes'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlanBoxes',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanBoxesResponse',
            []
        );
    }

    /**
     * Create request for operation 'listInboundPlanBoxes'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listInboundPlanBoxesRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listInboundPlanBoxes'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listInboundPlanBoxes, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listInboundPlanBoxes, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listInboundPlanBoxes, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlanBoxes, must be smaller than or equal to 1000.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlanBoxes, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlanBoxes, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlanBoxes, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/boxes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listInboundPlanItems.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlanItems(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanItemsResponse
    {
        $request = $this->listInboundPlanItemsRequest($accessToken, $region, $inbound_plan_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listInboundPlanItems', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlanItems')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlanItems'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlanItems',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listInboundPlanItems', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlanItems')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlanItems'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlanItems',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanItemsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listInboundPlanItems'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listInboundPlanItemsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listInboundPlanItems'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listInboundPlanItems, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listInboundPlanItems, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listInboundPlanItems, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlanItems, must be smaller than or equal to 1000.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlanItems, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlanItems, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlanItems, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listInboundPlanPallets.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of pallets to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlanPallets(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanPalletsResponse
    {
        $request = $this->listInboundPlanPalletsRequest($accessToken, $region, $inbound_plan_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listInboundPlanPallets', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlanPallets')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlanPallets'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlanPallets',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listInboundPlanPallets', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlanPallets')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlanPallets'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlanPallets',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlanPalletsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listInboundPlanPallets'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of pallets to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listInboundPlanPalletsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listInboundPlanPallets'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listInboundPlanPallets, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listInboundPlanPallets, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listInboundPlanPallets, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlanPallets, must be smaller than or equal to 1000.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlanPallets, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlanPallets, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlanPallets, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/pallets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listInboundPlans.
     *
     * @param null|int $page_size The number of inbound plans to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     * @param null|string $status The status of an inbound plan. (optional)
     * @param null|string $sort_by Sort by field. (optional)
     * @param null|string $sort_order The sort order. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listInboundPlans(AccessToken $accessToken, string $region, ?int $page_size = 10, ?string $pagination_token = null, ?string $status = null, ?string $sort_by = null, ?string $sort_order = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlansResponse
    {
        $request = $this->listInboundPlansRequest($accessToken, $region, $page_size, $pagination_token, $status, $sort_by, $sort_order);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listInboundPlans', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlans')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlans'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlans',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listInboundPlans', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listInboundPlans')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listInboundPlans'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listInboundPlans',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListInboundPlansResponse',
            []
        );
    }

    /**
     * Create request for operation 'listInboundPlans'.
     *
     * @param null|int $page_size The number of inbound plans to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     * @param null|string $status The status of an inbound plan. (optional)
     * @param null|string $sort_by Sort by field. (optional)
     * @param null|string $sort_order The sort order. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listInboundPlansRequest(AccessToken $accessToken, string $region, ?int $page_size = 10, ?string $pagination_token = null, ?string $status = null, ?string $sort_by = null, ?string $sort_order = null) : RequestInterface
    {
        if ($page_size !== null && $page_size > 30) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlans, must be smaller than or equal to 30.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listInboundPlans, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlans, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listInboundPlans, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        // query params
        if (\is_array($status)) {
            $status = ObjectSerializer::serializeCollection($status, '', true);
        }

        if ($status !== null) {
            $queryParams['status'] = ObjectSerializer::toString($status);
        }

        // query params
        if (\is_array($sort_by)) {
            $sort_by = ObjectSerializer::serializeCollection($sort_by, '', true);
        }

        if ($sort_by !== null) {
            $queryParams['sortBy'] = ObjectSerializer::toString($sort_by);
        }

        // query params
        if (\is_array($sort_order)) {
            $sort_order = ObjectSerializer::serializeCollection($sort_order, '', true);
        }

        if ($sort_order !== null) {
            $queryParams['sortOrder'] = ObjectSerializer::toString($sort_order);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listItemComplianceDetails.
     *
     * @param string[] $mskus A list of merchant SKUs, a merchant-supplied identifier of a specific SKU. (required)
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listItemComplianceDetails(AccessToken $accessToken, string $region, array $mskus, string $marketplace_id) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListItemComplianceDetailsResponse
    {
        $request = $this->listItemComplianceDetailsRequest($accessToken, $region, $mskus, $marketplace_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listItemComplianceDetails', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listItemComplianceDetails')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listItemComplianceDetails'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listItemComplianceDetails',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listItemComplianceDetails', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listItemComplianceDetails')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listItemComplianceDetails'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listItemComplianceDetails',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListItemComplianceDetailsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listItemComplianceDetails'.
     *
     * @param string[] $mskus A list of merchant SKUs, a merchant-supplied identifier of a specific SKU. (required)
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     *
     * @throws InvalidArgumentException
     */
    public function listItemComplianceDetailsRequest(AccessToken $accessToken, string $region, array $mskus, string $marketplace_id) : RequestInterface
    {
        // verify the required parameter 'mskus' is set
        if ($mskus === null || (\is_array($mskus) && \count($mskus) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $mskus when calling listItemComplianceDetails'
            );
        }

        if (\count($mskus) > 100) {
            throw new InvalidArgumentException('invalid value for "$mskus" when calling FbaInboundApi.listItemComplianceDetails, number of items must be less than or equal to 100.');
        }

        if (\count($mskus) < 1) {
            throw new InvalidArgumentException('invalid value for "$mskus" when calling FbaInboundApi.listItemComplianceDetails, number of items must be greater than or equal to 1.');
        }

        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (\is_array($marketplace_id) && \count($marketplace_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling listItemComplianceDetails'
            );
        }

        if (\strlen($marketplace_id) > 20) {
            throw new InvalidArgumentException('invalid length for "$marketplace_id" when calling FbaInboundApi.listItemComplianceDetails, must be smaller than or equal to 20.');
        }

        if (\strlen($marketplace_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$marketplace_id" when calling FbaInboundApi.listItemComplianceDetails, must be bigger than or equal to 1.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/items/compliance';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if ($mskus !== null) {
            if ('form' === 'form' && \is_array($mskus)) {
                foreach ($mskus as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['mskus'] = $mskus;
            }
        }

        // query params
        if (\is_array($marketplace_id)) {
            $marketplace_id = ObjectSerializer::serializeCollection($marketplace_id, '', true);
        }

        if ($marketplace_id !== null) {
            $queryParams['marketplaceId'] = ObjectSerializer::toString($marketplace_id);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listPackingGroupBoxes.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_group_id Identifier of a packing group. (required)
     * @param null|int $page_size The number of packing group boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPackingGroupBoxes(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_group_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingGroupBoxesResponse
    {
        $request = $this->listPackingGroupBoxesRequest($accessToken, $region, $inbound_plan_id, $packing_group_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listPackingGroupBoxes', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPackingGroupBoxes')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPackingGroupBoxes'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPackingGroupBoxes',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listPackingGroupBoxes', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPackingGroupBoxes')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPackingGroupBoxes'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPackingGroupBoxes',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingGroupBoxesResponse',
            []
        );
    }

    /**
     * Create request for operation 'listPackingGroupBoxes'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_group_id Identifier of a packing group. (required)
     * @param null|int $page_size The number of packing group boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listPackingGroupBoxesRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_group_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listPackingGroupBoxes'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPackingGroupBoxes, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPackingGroupBoxes, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listPackingGroupBoxes, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'packing_group_id' is set
        if ($packing_group_id === null || (\is_array($packing_group_id) && \count($packing_group_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $packing_group_id when calling listPackingGroupBoxes'
            );
        }

        if (\strlen($packing_group_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$packing_group_id" when calling FbaInboundApi.listPackingGroupBoxes, must be smaller than or equal to 38.');
        }

        if (\strlen($packing_group_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$packing_group_id" when calling FbaInboundApi.listPackingGroupBoxes, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $packing_group_id)) {
            throw new InvalidArgumentException('invalid value for "packing_group_id" when calling FbaInboundApi.listPackingGroupBoxes, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 100) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPackingGroupBoxes, must be smaller than or equal to 100.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPackingGroupBoxes, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPackingGroupBoxes, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPackingGroupBoxes, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingGroups/{packingGroupId}/boxes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($packing_group_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'packingGroupId' . '}',
                ObjectSerializer::toPathValue($packing_group_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listPackingGroupItems.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_group_id Identifier of a packing group. (required)
     * @param null|int $page_size The number of packing group items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPackingGroupItems(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_group_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingGroupItemsResponse
    {
        $request = $this->listPackingGroupItemsRequest($accessToken, $region, $inbound_plan_id, $packing_group_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listPackingGroupItems', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPackingGroupItems')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPackingGroupItems'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPackingGroupItems',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listPackingGroupItems', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPackingGroupItems')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPackingGroupItems'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPackingGroupItems',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingGroupItemsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listPackingGroupItems'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $packing_group_id Identifier of a packing group. (required)
     * @param null|int $page_size The number of packing group items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listPackingGroupItemsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $packing_group_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listPackingGroupItems'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPackingGroupItems, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPackingGroupItems, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listPackingGroupItems, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'packing_group_id' is set
        if ($packing_group_id === null || (\is_array($packing_group_id) && \count($packing_group_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $packing_group_id when calling listPackingGroupItems'
            );
        }

        if (\strlen($packing_group_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$packing_group_id" when calling FbaInboundApi.listPackingGroupItems, must be smaller than or equal to 38.');
        }

        if (\strlen($packing_group_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$packing_group_id" when calling FbaInboundApi.listPackingGroupItems, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $packing_group_id)) {
            throw new InvalidArgumentException('invalid value for "packing_group_id" when calling FbaInboundApi.listPackingGroupItems, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 100) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPackingGroupItems, must be smaller than or equal to 100.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPackingGroupItems, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPackingGroupItems, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPackingGroupItems, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingGroups/{packingGroupId}/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($packing_group_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'packingGroupId' . '}',
                ObjectSerializer::toPathValue($packing_group_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listPackingOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of packing options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPackingOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingOptionsResponse
    {
        $request = $this->listPackingOptionsRequest($accessToken, $region, $inbound_plan_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listPackingOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPackingOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPackingOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPackingOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listPackingOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPackingOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPackingOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPackingOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPackingOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listPackingOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of packing options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listPackingOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listPackingOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPackingOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPackingOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listPackingOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 20) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPackingOptions, must be smaller than or equal to 20.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPackingOptions, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPackingOptions, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPackingOptions, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listPlacementOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of placement options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPlacementOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPlacementOptionsResponse
    {
        $request = $this->listPlacementOptionsRequest($accessToken, $region, $inbound_plan_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listPlacementOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPlacementOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPlacementOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPlacementOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listPlacementOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPlacementOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPlacementOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPlacementOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPlacementOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listPlacementOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of placement options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listPlacementOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listPlacementOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPlacementOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listPlacementOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listPlacementOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 20) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPlacementOptions, must be smaller than or equal to 20.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listPlacementOptions, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPlacementOptions, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listPlacementOptions, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/placementOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listPrepDetails.
     *
     * @param string $marketplace_id The marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param string[] $mskus A list of merchant SKUs, a merchant-supplied identifier of a specific SKU. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listPrepDetails(AccessToken $accessToken, string $region, string $marketplace_id, array $mskus) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPrepDetailsResponse
    {
        $request = $this->listPrepDetailsRequest($accessToken, $region, $marketplace_id, $mskus);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listPrepDetails', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPrepDetails')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPrepDetails'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPrepDetails',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listPrepDetails', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listPrepDetails')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listPrepDetails'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listPrepDetails',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListPrepDetailsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listPrepDetails'.
     *
     * @param string $marketplace_id The marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param string[] $mskus A list of merchant SKUs, a merchant-supplied identifier of a specific SKU. (required)
     *
     * @throws InvalidArgumentException
     */
    public function listPrepDetailsRequest(AccessToken $accessToken, string $region, string $marketplace_id, array $mskus) : RequestInterface
    {
        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (\is_array($marketplace_id) && \count($marketplace_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling listPrepDetails'
            );
        }

        if (\strlen($marketplace_id) > 20) {
            throw new InvalidArgumentException('invalid length for "$marketplace_id" when calling FbaInboundApi.listPrepDetails, must be smaller than or equal to 20.');
        }

        if (\strlen($marketplace_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$marketplace_id" when calling FbaInboundApi.listPrepDetails, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'mskus' is set
        if ($mskus === null || (\is_array($mskus) && \count($mskus) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $mskus when calling listPrepDetails'
            );
        }

        if (\count($mskus) > 100) {
            throw new InvalidArgumentException('invalid value for "$mskus" when calling FbaInboundApi.listPrepDetails, number of items must be less than or equal to 100.');
        }

        if (\count($mskus) < 1) {
            throw new InvalidArgumentException('invalid value for "$mskus" when calling FbaInboundApi.listPrepDetails, number of items must be greater than or equal to 1.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/items/prepDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($marketplace_id)) {
            $marketplace_id = ObjectSerializer::serializeCollection($marketplace_id, '', true);
        }

        if ($marketplace_id !== null) {
            $queryParams['marketplaceId'] = ObjectSerializer::toString($marketplace_id);
        }

        // query params
        if ($mskus !== null) {
            if ('form' === 'form' && \is_array($mskus)) {
                foreach ($mskus as $key => $value) {
                    $queryParams[$key] = $value;
                }
            } else {
                $queryParams['mskus'] = $mskus;
            }
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listShipmentBoxes.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentBoxes(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentBoxesResponse
    {
        $request = $this->listShipmentBoxesRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listShipmentBoxes', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentBoxes')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentBoxes'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentBoxes',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listShipmentBoxes', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentBoxes')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentBoxes'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentBoxes',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentBoxesResponse',
            []
        );
    }

    /**
     * Create request for operation 'listShipmentBoxes'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of boxes to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listShipmentBoxesRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listShipmentBoxes'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentBoxes, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentBoxes, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listShipmentBoxes, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling listShipmentBoxes'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentBoxes, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentBoxes, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.listShipmentBoxes, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentBoxes, must be smaller than or equal to 1000.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentBoxes, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentBoxes, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentBoxes, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/boxes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listShipmentContentUpdatePreviews.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of content update previews to return. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentContentUpdatePreviews(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentContentUpdatePreviewsResponse
    {
        $request = $this->listShipmentContentUpdatePreviewsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listShipmentContentUpdatePreviews', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentContentUpdatePreviews')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentContentUpdatePreviews'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentContentUpdatePreviews',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listShipmentContentUpdatePreviews', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentContentUpdatePreviews')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentContentUpdatePreviews'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentContentUpdatePreviews',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentContentUpdatePreviewsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listShipmentContentUpdatePreviews'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of content update previews to return. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listShipmentContentUpdatePreviewsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listShipmentContentUpdatePreviews'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling listShipmentContentUpdatePreviews'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 20) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be smaller than or equal to 20.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentContentUpdatePreviews, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/contentUpdatePreviews';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listShipmentItems.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentItems(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentItemsResponse
    {
        $request = $this->listShipmentItemsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listShipmentItems', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentItems')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentItems'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentItems',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listShipmentItems', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentItems')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentItems'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentItems',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentItemsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listShipmentItems'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of items to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listShipmentItemsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listShipmentItems'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentItems, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentItems, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listShipmentItems, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling listShipmentItems'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentItems, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentItems, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.listShipmentItems, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentItems, must be smaller than or equal to 1000.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentItems, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentItems, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentItems, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/items';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listShipmentPallets.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of pallets to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listShipmentPallets(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentPalletsResponse
    {
        $request = $this->listShipmentPalletsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $page_size, $pagination_token);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listShipmentPallets', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentPallets')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentPallets'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentPallets',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listShipmentPallets', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listShipmentPallets')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listShipmentPallets'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listShipmentPallets',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListShipmentPalletsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listShipmentPallets'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param null|int $page_size The number of pallets to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listShipmentPalletsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, ?int $page_size = 10, ?string $pagination_token = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listShipmentPallets'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentPallets, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listShipmentPallets, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listShipmentPallets, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling listShipmentPallets'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentPallets, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listShipmentPallets, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.listShipmentPallets, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 1000) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentPallets, must be smaller than or equal to 1000.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listShipmentPallets, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentPallets, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listShipmentPallets, must be bigger than or equal to 0.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/pallets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation listTransportationOptions.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of transportation options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     * @param null|string $placement_option_id The placement option to get transportation options for. Either &#x60;placementOptionId&#x60; or &#x60;shipmentId&#x60; must be specified. (optional)
     * @param null|string $shipment_id The shipment to get transportation options for. Either &#x60;placementOptionId&#x60; or &#x60;shipmentId&#x60; must be specified. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function listTransportationOptions(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null, ?string $placement_option_id = null, ?string $shipment_id = null) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListTransportationOptionsResponse
    {
        $request = $this->listTransportationOptionsRequest($accessToken, $region, $inbound_plan_id, $page_size, $pagination_token, $placement_option_id, $shipment_id);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'listTransportationOptions', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listTransportationOptions')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listTransportationOptions'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listTransportationOptions',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'listTransportationOptions', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'listTransportationOptions')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'listTransportationOptions'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'listTransportationOptions',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ListTransportationOptionsResponse',
            []
        );
    }

    /**
     * Create request for operation 'listTransportationOptions'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param null|int $page_size The number of transportation options to return in the response matching the given query. (optional, default to 10)
     * @param null|string $pagination_token A token to fetch a certain page when there are multiple pages worth of results. The value of this token is fetched from the &#x60;pagination&#x60; returned in the API response. In the absence of the token value from the query parameter the API returns the first page of the result. (optional)
     * @param null|string $placement_option_id The placement option to get transportation options for. Either &#x60;placementOptionId&#x60; or &#x60;shipmentId&#x60; must be specified. (optional)
     * @param null|string $shipment_id The shipment to get transportation options for. Either &#x60;placementOptionId&#x60; or &#x60;shipmentId&#x60; must be specified. (optional)
     *
     * @throws InvalidArgumentException
     */
    public function listTransportationOptionsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, ?int $page_size = 10, ?string $pagination_token = null, ?string $placement_option_id = null, ?string $shipment_id = null) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling listTransportationOptions'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listTransportationOptions, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.listTransportationOptions, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.listTransportationOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($page_size !== null && $page_size > 20) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listTransportationOptions, must be smaller than or equal to 20.');
        }

        if ($page_size !== null && $page_size < 1) {
            throw new InvalidArgumentException('invalid value for "$page_size" when calling FbaInboundApi.listTransportationOptions, must be bigger than or equal to 1.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) > 1024) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listTransportationOptions, must be smaller than or equal to 1024.');
        }

        if ($pagination_token !== null && \strlen($pagination_token) < 0) {
            throw new InvalidArgumentException('invalid length for "$pagination_token" when calling FbaInboundApi.listTransportationOptions, must be bigger than or equal to 0.');
        }

        if ($placement_option_id !== null && \strlen($placement_option_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$placement_option_id" when calling FbaInboundApi.listTransportationOptions, must be smaller than or equal to 38.');
        }

        if ($placement_option_id !== null && \strlen($placement_option_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$placement_option_id" when calling FbaInboundApi.listTransportationOptions, must be bigger than or equal to 38.');
        }

        if ($placement_option_id !== null && !\preg_match('/^[a-zA-Z0-9-]*$/', $placement_option_id)) {
            throw new InvalidArgumentException('invalid value for "placement_option_id" when calling FbaInboundApi.listTransportationOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        if ($shipment_id !== null && \strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listTransportationOptions, must be smaller than or equal to 38.');
        }

        if ($shipment_id !== null && \strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.listTransportationOptions, must be bigger than or equal to 38.');
        }

        if ($shipment_id !== null && !\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.listTransportationOptions, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/transportationOptions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($page_size)) {
            $page_size = ObjectSerializer::serializeCollection($page_size, '', true);
        }

        if ($page_size !== null) {
            $queryParams['pageSize'] = ObjectSerializer::toString($page_size);
        }

        // query params
        if (\is_array($pagination_token)) {
            $pagination_token = ObjectSerializer::serializeCollection($pagination_token, '', true);
        }

        if ($pagination_token !== null) {
            $queryParams['paginationToken'] = ObjectSerializer::toString($pagination_token);
        }

        // query params
        if (\is_array($placement_option_id)) {
            $placement_option_id = ObjectSerializer::serializeCollection($placement_option_id, '', true);
        }

        if ($placement_option_id !== null) {
            $queryParams['placementOptionId'] = ObjectSerializer::toString($placement_option_id);
        }

        // query params
        if (\is_array($shipment_id)) {
            $shipment_id = ObjectSerializer::serializeCollection($shipment_id, '', true);
        }

        if ($shipment_id !== null) {
            $queryParams['shipmentId'] = ObjectSerializer::toString($shipment_id);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'GET',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation scheduleSelfShipAppointment.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $slot_id An identifier to a self-ship appointment slot. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentRequest $body The body of the request to &#x60;scheduleSelfShipAppointment&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function scheduleSelfShipAppointment(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $slot_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentResponse
    {
        $request = $this->scheduleSelfShipAppointmentRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $slot_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'scheduleSelfShipAppointment', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'scheduleSelfShipAppointment')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'scheduleSelfShipAppointment'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'scheduleSelfShipAppointment',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'scheduleSelfShipAppointment', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'scheduleSelfShipAppointment')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'scheduleSelfShipAppointment'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'scheduleSelfShipAppointment',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentResponse',
            []
        );
    }

    /**
     * Create request for operation 'scheduleSelfShipAppointment'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param string $slot_id An identifier to a self-ship appointment slot. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentRequest $body The body of the request to &#x60;scheduleSelfShipAppointment&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function scheduleSelfShipAppointmentRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, string $slot_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\ScheduleSelfShipAppointmentRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling scheduleSelfShipAppointment'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling scheduleSelfShipAppointment'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'slot_id' is set
        if ($slot_id === null || (\is_array($slot_id) && \count($slot_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $slot_id when calling scheduleSelfShipAppointment'
            );
        }

        if (\strlen($slot_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$slot_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must be smaller than or equal to 38.');
        }

        if (\strlen($slot_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$slot_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $slot_id)) {
            throw new InvalidArgumentException('invalid value for "slot_id" when calling FbaInboundApi.scheduleSelfShipAppointment, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling scheduleSelfShipAppointment'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/selfShipAppointmentSlots/{slotId}/schedule';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        // path params
        if ($slot_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'slotId' . '}',
                ObjectSerializer::toPathValue($slot_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation setPackingInformation.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationRequest $body The body of the request to &#x60;setPackingInformation&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function setPackingInformation(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationResponse
    {
        $request = $this->setPackingInformationRequest($accessToken, $region, $inbound_plan_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'setPackingInformation', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'setPackingInformation')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'setPackingInformation'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'setPackingInformation',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'setPackingInformation', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'setPackingInformation')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'setPackingInformation'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'setPackingInformation',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationResponse',
            []
        );
    }

    /**
     * Create request for operation 'setPackingInformation'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationRequest $body The body of the request to &#x60;setPackingInformation&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function setPackingInformationRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPackingInformationRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling setPackingInformation'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.setPackingInformation, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.setPackingInformation, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.setPackingInformation, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling setPackingInformation'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/packingInformation';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation setPrepDetails.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsRequest $body The body of the request to &#x60;setPrepDetails&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function setPrepDetails(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsResponse
    {
        $request = $this->setPrepDetailsRequest($accessToken, $region, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'setPrepDetails', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'setPrepDetails')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'setPrepDetails'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'setPrepDetails',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'setPrepDetails', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'setPrepDetails')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'setPrepDetails'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'setPrepDetails',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsResponse',
            []
        );
    }

    /**
     * Create request for operation 'setPrepDetails'.
     *
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsRequest $body The body of the request to &#x60;setPrepDetails&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function setPrepDetailsRequest(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\SetPrepDetailsRequest $body) : RequestInterface
    {
        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling setPrepDetails'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/items/prepDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'POST',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation updateInboundPlanName.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateInboundPlanNameRequest $body The body of the request to &#x60;updateInboundPlanName&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateInboundPlanName(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateInboundPlanNameRequest $body)
    {
        $request = $this->updateInboundPlanNameRequest($accessToken, $region, $inbound_plan_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'updateInboundPlanName', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateInboundPlanName')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateInboundPlanName'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateInboundPlanName',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'updateInboundPlanName', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateInboundPlanName')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateInboundPlanName'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateInboundPlanName',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return null;
    }

    /**
     * Create request for operation 'updateInboundPlanName'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateInboundPlanNameRequest $body The body of the request to &#x60;updateInboundPlanName&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function updateInboundPlanNameRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateInboundPlanNameRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling updateInboundPlanName'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateInboundPlanName, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateInboundPlanName, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.updateInboundPlanName, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling updateInboundPlanName'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/name';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation updateItemComplianceDetails.
     *
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsRequest $body The body of the request to &#x60;updateItemComplianceDetails&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateItemComplianceDetails(AccessToken $accessToken, string $region, string $marketplace_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsResponse
    {
        $request = $this->updateItemComplianceDetailsRequest($accessToken, $region, $marketplace_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'updateItemComplianceDetails', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateItemComplianceDetails')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateItemComplianceDetails'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateItemComplianceDetails',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'updateItemComplianceDetails', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateItemComplianceDetails')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateItemComplianceDetails'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateItemComplianceDetails',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsResponse',
            []
        );
    }

    /**
     * Create request for operation 'updateItemComplianceDetails'.
     *
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids). (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsRequest $body The body of the request to &#x60;updateItemComplianceDetails&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function updateItemComplianceDetailsRequest(AccessToken $accessToken, string $region, string $marketplace_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateItemComplianceDetailsRequest $body) : RequestInterface
    {
        // verify the required parameter 'marketplace_id' is set
        if ($marketplace_id === null || (\is_array($marketplace_id) && \count($marketplace_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $marketplace_id when calling updateItemComplianceDetails'
            );
        }

        if (\strlen($marketplace_id) > 20) {
            throw new InvalidArgumentException('invalid length for "$marketplace_id" when calling FbaInboundApi.updateItemComplianceDetails, must be smaller than or equal to 20.');
        }

        if (\strlen($marketplace_id) < 1) {
            throw new InvalidArgumentException('invalid length for "$marketplace_id" when calling FbaInboundApi.updateItemComplianceDetails, must be bigger than or equal to 1.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling updateItemComplianceDetails'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/items/compliance';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        // query params
        if (\is_array($marketplace_id)) {
            $marketplace_id = ObjectSerializer::serializeCollection($marketplace_id, '', true);
        }

        if ($marketplace_id !== null) {
            $queryParams['marketplaceId'] = ObjectSerializer::toString($marketplace_id);
        }

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation updateShipmentName.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentNameRequest $body The body of the request to &#x60;updateShipmentName&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateShipmentName(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentNameRequest $body)
    {
        $request = $this->updateShipmentNameRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'updateShipmentName', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateShipmentName')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateShipmentName'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateShipmentName',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'updateShipmentName', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateShipmentName')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateShipmentName'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateShipmentName',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return null;
    }

    /**
     * Create request for operation 'updateShipmentName'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentNameRequest $body The body of the request to &#x60;updateShipmentName&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function updateShipmentNameRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentNameRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling updateShipmentName'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateShipmentName, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateShipmentName, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.updateShipmentName, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling updateShipmentName'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.updateShipmentName, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.updateShipmentName, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.updateShipmentName, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling updateShipmentName'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/name';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation updateShipmentSourceAddress.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressRequest $body The body of the request to &#x60;updateShipmentSourceAddress&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateShipmentSourceAddress(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressResponse
    {
        $request = $this->updateShipmentSourceAddressRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'updateShipmentSourceAddress', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateShipmentSourceAddress')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateShipmentSourceAddress'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateShipmentSourceAddress',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'updateShipmentSourceAddress', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateShipmentSourceAddress')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateShipmentSourceAddress'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateShipmentSourceAddress',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressResponse',
            []
        );
    }

    /**
     * Create request for operation 'updateShipmentSourceAddress'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressRequest $body The body of the request to &#x60;updateShipmentSourceAddress&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function updateShipmentSourceAddressRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentSourceAddressRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling updateShipmentSourceAddress'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateShipmentSourceAddress, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateShipmentSourceAddress, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.updateShipmentSourceAddress, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling updateShipmentSourceAddress'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.updateShipmentSourceAddress, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.updateShipmentSourceAddress, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.updateShipmentSourceAddress, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling updateShipmentSourceAddress'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/sourceAddress';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }

    /**
     * Operation updateShipmentTrackingDetails.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsRequest $body The body of the request to &#x60;updateShipmentTrackingDetails&#x60;. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateShipmentTrackingDetails(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsRequest $body) : \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsResponse
    {
        $request = $this->updateShipmentTrackingDetailsRequest($accessToken, $region, $inbound_plan_id, $shipment_id, $body);

        $this->configuration->extensions()->preRequest('FulfillmentInbound', 'updateShipmentTrackingDetails', $request);

        try {
            $correlationId = $this->configuration->idGenerator()->generate();
            $sanitizedRequest = $request;

            foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                $sanitizedRequest = $sanitizedRequest->withoutHeader($sensitiveHeader);
            }

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateShipmentTrackingDetails')) {
                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateShipmentTrackingDetails'),
                    'Amazon Selling Partner API pre request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateShipmentTrackingDetails',
                        'request_correlation_id' => $correlationId,
                        'request_body' => (string) $sanitizedRequest->getBody(),
                        'request_headers' => $sanitizedRequest->getHeaders(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                    ]
                );
            }

            $response = $this->client->sendRequest($request);

            $this->configuration->extensions()->postRequest('FulfillmentInbound', 'updateShipmentTrackingDetails', $request, $response);

            if ($this->configuration->loggingEnabled('FulfillmentInbound', 'updateShipmentTrackingDetails')) {
                $sanitizedResponse = $response;

                foreach ($this->configuration->loggingSkipHeaders() as $sensitiveHeader) {
                    $sanitizedResponse = $sanitizedResponse->withoutHeader($sensitiveHeader);
                }

                $this->logger->log(
                    $this->configuration->logLevel('FulfillmentInbound', 'updateShipmentTrackingDetails'),
                    'Amazon Selling Partner API post request',
                    [
                        'api' => 'FulfillmentInbound',
                        'operation' => 'updateShipmentTrackingDetails',
                        'response_correlation_id' => $correlationId,
                        'response_body' => (string) $sanitizedResponse->getBody(),
                        'response_headers' => $sanitizedResponse->getHeaders(),
                        'response_status_code' => $sanitizedResponse->getStatusCode(),
                        'request_uri' => (string) $sanitizedRequest->getUri(),
                        'request_body' => (string) $sanitizedRequest->getBody(),
                    ]
                );
            }
        } catch (ClientExceptionInterface $e) {
            throw new ApiException(
                "[{$e->getCode()}] {$e->getMessage()}",
                (int) $e->getCode(),
                null,
                null,
                $e
            );
        }

        $statusCode = $response->getStatusCode();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                \sprintf(
                    '[%d] Error connecting to the API (%s)',
                    $statusCode,
                    (string) $request->getUri()
                ),
                $statusCode,
                $response->getHeaders(),
                (string) $response->getBody()
            );
        }

        return ObjectSerializer::deserialize(
            $this->configuration,
            (string) $response->getBody(),
            '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsResponse',
            []
        );
    }

    /**
     * Create request for operation 'updateShipmentTrackingDetails'.
     *
     * @param string $inbound_plan_id Identifier of an inbound plan. (required)
     * @param string $shipment_id Identifier of a shipment. A shipment contains the boxes and units being inbounded. (required)
     * @param \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsRequest $body The body of the request to &#x60;updateShipmentTrackingDetails&#x60;. (required)
     *
     * @throws InvalidArgumentException
     */
    public function updateShipmentTrackingDetailsRequest(AccessToken $accessToken, string $region, string $inbound_plan_id, string $shipment_id, \AmazonPHP\SellingPartner\Model\FulfillmentInbound\UpdateShipmentTrackingDetailsRequest $body) : RequestInterface
    {
        // verify the required parameter 'inbound_plan_id' is set
        if ($inbound_plan_id === null || (\is_array($inbound_plan_id) && \count($inbound_plan_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $inbound_plan_id when calling updateShipmentTrackingDetails'
            );
        }

        if (\strlen($inbound_plan_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateShipmentTrackingDetails, must be smaller than or equal to 38.');
        }

        if (\strlen($inbound_plan_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$inbound_plan_id" when calling FbaInboundApi.updateShipmentTrackingDetails, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $inbound_plan_id)) {
            throw new InvalidArgumentException('invalid value for "inbound_plan_id" when calling FbaInboundApi.updateShipmentTrackingDetails, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'shipment_id' is set
        if ($shipment_id === null || (\is_array($shipment_id) && \count($shipment_id) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $shipment_id when calling updateShipmentTrackingDetails'
            );
        }

        if (\strlen($shipment_id) > 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.updateShipmentTrackingDetails, must be smaller than or equal to 38.');
        }

        if (\strlen($shipment_id) < 38) {
            throw new InvalidArgumentException('invalid length for "$shipment_id" when calling FbaInboundApi.updateShipmentTrackingDetails, must be bigger than or equal to 38.');
        }

        if (!\preg_match('/^[a-zA-Z0-9-]*$/', $shipment_id)) {
            throw new InvalidArgumentException('invalid value for "shipment_id" when calling FbaInboundApi.updateShipmentTrackingDetails, must conform to the pattern /^[a-zA-Z0-9-]*$/.');
        }

        // verify the required parameter 'body' is set
        if ($body === null || (\is_array($body) && \count($body) === 0)) {
            throw new InvalidArgumentException(
                'Missing the required parameter $body when calling updateShipmentTrackingDetails'
            );
        }

        $resourcePath = '/inbound/fba/2024-03-20/inboundPlans/{inboundPlanId}/shipments/{shipmentId}/trackingDetails';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $multipart = false;
        $query = '';

        if (\count($queryParams)) {
            $query = \http_build_query($queryParams);
        }

        // path params
        if ($inbound_plan_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'inboundPlanId' . '}',
                ObjectSerializer::toPathValue($inbound_plan_id),
                $resourcePath
            );
        }

        // path params
        if ($shipment_id !== null) {
            $resourcePath = \str_replace(
                '{' . 'shipmentId' . '}',
                ObjectSerializer::toPathValue($shipment_id),
                $resourcePath
            );
        }

        if ($multipart) {
            $headers = [
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        } else {
            $headers = [
                'content-type' => ['application/json'],
                'accept' => ['application/json'],
                'host' => [$this->configuration->apiHost($region)],
                'user-agent' => [$this->configuration->userAgent()],
            ];
        }

        $request = $this->httpFactory->createRequest(
            'PUT',
            $this->configuration->apiURL($region) . $resourcePath . '?' . $query
        );

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['content-type'] === ['application/json']) {
                $httpBody = \json_encode(ObjectSerializer::sanitizeForSerialization($body), JSON_THROW_ON_ERROR);
            } else {
                $httpBody = $body;
            }

            $request = $request->withBody($this->httpFactory->createStreamFromString($httpBody));
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];

                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = \is_array($formParamValue) ? $formParamValue : [$formParamValue];

                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem,
                        ];
                    }
                }
                $request = $request->withParsedBody($multipartContents);
            } elseif ($headers['content-type'] === ['application/json']) {
                $request = $request->withBody($this->httpFactory->createStreamFromString(\json_encode($formParams, JSON_THROW_ON_ERROR)));
            } else {
                $request = $request->withParsedBody($formParams);
            }
        }

        foreach (\array_merge($headerParams, $headers) as $name => $header) {
            $request = $request->withHeader($name, $header);
        }

        return HttpSignatureHeaders::forConfig(
            $this->configuration,
            $accessToken,
            $region,
            $request
        );
    }
}
