<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\SellersApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * The Selling Partner API for Sellers.
 *
 * The Selling Partner API for Sellers lets you retrieve information on behalf of sellers about their seller account, such as the marketplaces they participate in. Along with listing the marketplaces that a seller can sell in, the API also provides additional information about the marketplace such as the default language and the default currency. The API also provides seller-specific information such as whether the seller has suspended listings in that marketplace.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface SellersSDKInterface
{
    public const API_NAME = 'Sellers';

    public const OPERATION_GETACCOUNT = 'getAccount';

    public const OPERATION_GETACCOUNT_PATH = '/sellers/v1/account';

    public const OPERATION_GETMARKETPLACEPARTICIPATIONS = 'getMarketplaceParticipations';

    public const OPERATION_GETMARKETPLACEPARTICIPATIONS_PATH = '/sellers/v1/marketplaceParticipations';

    /**
     * Operation getAccount.
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getAccount(AccessToken $accessToken, string $region) : \AmazonPHP\SellingPartner\Model\Sellers\GetAccountResponse;

    /**
     * Operation getMarketplaceParticipations.
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getMarketplaceParticipations(AccessToken $accessToken, string $region) : \AmazonPHP\SellingPartner\Model\Sellers\GetMarketplaceParticipationsResponse;
}
