<?php declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Api\ServiceApi;

use AmazonPHP\SellingPartner\AccessToken;
use AmazonPHP\SellingPartner\Exception\ApiException;
use AmazonPHP\SellingPartner\Exception\InvalidArgumentException;

/**
 * Selling Partner API for Services.
 *
 * With the Services API, you can build applications that help service providers get and modify their service orders and manage their resources.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
interface ServicesSDKInterface
{
    public const API_NAME = 'Services';

    public const OPERATION_ADDAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID = 'addAppointmentForServiceJobByServiceJobId';

    public const OPERATION_ADDAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointments';

    public const OPERATION_ASSIGNAPPOINTMENTRESOURCES = 'assignAppointmentResources';

    public const OPERATION_ASSIGNAPPOINTMENTRESOURCES_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/resources';

    public const OPERATION_CANCELRESERVATION = 'cancelReservation';

    public const OPERATION_CANCELRESERVATION_PATH = '/service/v1/reservation/{reservationId}';

    public const OPERATION_CANCELSERVICEJOBBYSERVICEJOBID = 'cancelServiceJobByServiceJobId';

    public const OPERATION_CANCELSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/cancellations';

    public const OPERATION_COMPLETESERVICEJOBBYSERVICEJOBID = 'completeServiceJobByServiceJobId';

    public const OPERATION_COMPLETESERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/completions';

    public const OPERATION_CREATERESERVATION = 'createReservation';

    public const OPERATION_CREATERESERVATION_PATH = '/service/v1/reservation';

    public const OPERATION_CREATESERVICEDOCUMENTUPLOADDESTINATION = 'createServiceDocumentUploadDestination';

    public const OPERATION_CREATESERVICEDOCUMENTUPLOADDESTINATION_PATH = '/service/v1/documents';

    public const OPERATION_GETAPPOINTMENTSLOTS = 'getAppointmentSlots';

    public const OPERATION_GETAPPOINTMENTSLOTS_PATH = '/service/v1/appointmentSlots';

    public const OPERATION_GETAPPOINTMMENTSLOTSBYJOBID = 'getAppointmmentSlotsByJobId';

    public const OPERATION_GETAPPOINTMMENTSLOTSBYJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointmentSlots';

    public const OPERATION_GETFIXEDSLOTCAPACITY = 'getFixedSlotCapacity';

    public const OPERATION_GETFIXEDSLOTCAPACITY_PATH = '/service/v1/serviceResources/{resourceId}/capacity/fixed';

    public const OPERATION_GETRANGESLOTCAPACITY = 'getRangeSlotCapacity';

    public const OPERATION_GETRANGESLOTCAPACITY_PATH = '/service/v1/serviceResources/{resourceId}/capacity/range';

    public const OPERATION_GETSERVICEJOBBYSERVICEJOBID = 'getServiceJobByServiceJobId';

    public const OPERATION_GETSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}';

    public const OPERATION_GETSERVICEJOBS = 'getServiceJobs';

    public const OPERATION_GETSERVICEJOBS_PATH = '/service/v1/serviceJobs';

    public const OPERATION_RESCHEDULEAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID = 'rescheduleAppointmentForServiceJobByServiceJobId';

    public const OPERATION_RESCHEDULEAPPOINTMENTFORSERVICEJOBBYSERVICEJOBID_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}';

    public const OPERATION_SETAPPOINTMENTFULFILLMENTDATA = 'setAppointmentFulfillmentData';

    public const OPERATION_SETAPPOINTMENTFULFILLMENTDATA_PATH = '/service/v1/serviceJobs/{serviceJobId}/appointments/{appointmentId}/fulfillment';

    public const OPERATION_UPDATERESERVATION = 'updateReservation';

    public const OPERATION_UPDATERESERVATION_PATH = '/service/v1/reservation/{reservationId}';

    public const OPERATION_UPDATESCHEDULE = 'updateSchedule';

    public const OPERATION_UPDATESCHEDULE_PATH = '/service/v1/serviceResources/{resourceId}/schedules';

    /**
     * Operation addAppointmentForServiceJobByServiceJobId.
     *
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\AddAppointmentRequest $body Add appointment operation input details. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function addAppointmentForServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id, \AmazonPHP\SellingPartner\Model\Services\AddAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\Services\SetAppointmentResponse;

    /**
     * Operation assignAppointmentResources.
     *
     * @param string $service_job_id An Amazon-defined service job identifier. Get this value by calling the &#x60;getServiceJobs&#x60; operation of the Services API. (required)
     * @param string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\AssignAppointmentResourcesRequest $body body (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function assignAppointmentResources(AccessToken $accessToken, string $region, string $service_job_id, string $appointment_id, \AmazonPHP\SellingPartner\Model\Services\AssignAppointmentResourcesRequest $body) : \AmazonPHP\SellingPartner\Model\Services\AssignAppointmentResourcesResponse;

    /**
     * Operation cancelReservation.
     *
     * @param string $reservation_id Reservation Identifier (required)
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function cancelReservation(AccessToken $accessToken, string $region, string $reservation_id, array $marketplace_ids) : \AmazonPHP\SellingPartner\Model\Services\CancelReservationResponse;

    /**
     * Operation cancelServiceJobByServiceJobId.
     *
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param string $cancellation_reason_code A cancel reason code that specifies the reason for cancelling a service job. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function cancelServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id, string $cancellation_reason_code) : \AmazonPHP\SellingPartner\Model\Services\CancelServiceJobByServiceJobIdResponse;

    /**
     * Operation completeServiceJobByServiceJobId.
     *
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function completeServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id) : \AmazonPHP\SellingPartner\Model\Services\CompleteServiceJobByServiceJobIdResponse;

    /**
     * Operation createReservation.
     *
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\CreateReservationRequest $body Reservation details (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function createReservation(AccessToken $accessToken, string $region, array $marketplace_ids, \AmazonPHP\SellingPartner\Model\Services\CreateReservationRequest $body) : \AmazonPHP\SellingPartner\Model\Services\CreateReservationResponse;

    /**
     * Operation createServiceDocumentUploadDestination.
     *
     * @param \AmazonPHP\SellingPartner\Model\Services\ServiceUploadDocument $body Upload document operation input details. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function createServiceDocumentUploadDestination(AccessToken $accessToken, string $region, \AmazonPHP\SellingPartner\Model\Services\ServiceUploadDocument $body) : \AmazonPHP\SellingPartner\Model\Services\CreateServiceDocumentUploadDestination;

    /**
     * Operation getAppointmentSlots.
     *
     * @param string $asin ASIN associated with the service. (required)
     * @param string $store_id Store identifier defining the region scope to retrive appointment slots. (required)
     * @param string[] $marketplace_ids An identifier for the marketplace for which appointment slots are queried (required)
     * @param null|string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If &#x60;startTime&#x60; is provided, &#x60;endTime&#x60; should also be provided. Default value is as per business configuration. (optional)
     * @param null|string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If &#x60;endTime&#x60; is provided, &#x60;startTime&#x60; should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getAppointmentSlots(AccessToken $accessToken, string $region, string $asin, string $store_id, array $marketplace_ids, ?string $start_time = null, ?string $end_time = null) : \AmazonPHP\SellingPartner\Model\Services\GetAppointmentSlotsResponse;

    /**
     * Operation getAppointmmentSlotsByJobId.
     *
     * @param string $service_job_id A service job identifier to retrive appointment slots for associated service. (required)
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param null|string $start_time A time from which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If &#x60;startTime&#x60; is provided, &#x60;endTime&#x60; should also be provided. Default value is as per business configuration. (optional)
     * @param null|string $end_time A time up to which the appointment slots will be retrieved. The specified time must be in ISO 8601 format. If &#x60;endTime&#x60; is provided, &#x60;startTime&#x60; should also be provided. Default value is as per business configuration. Maximum range of appointment slots can be 90 days. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getAppointmmentSlotsByJobId(AccessToken $accessToken, string $region, string $service_job_id, array $marketplace_ids, ?string $start_time = null, ?string $end_time = null) : \AmazonPHP\SellingPartner\Model\Services\GetAppointmentSlotsResponse;

    /**
     * Operation getFixedSlotCapacity.
     *
     * @param string $resource_id Resource Identifier. (required)
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\FixedSlotCapacityQuery $body Request body. (required)
     * @param null|string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getFixedSlotCapacity(AccessToken $accessToken, string $region, string $resource_id, array $marketplace_ids, \AmazonPHP\SellingPartner\Model\Services\FixedSlotCapacityQuery $body, ?string $next_page_token = null) : \AmazonPHP\SellingPartner\Model\Services\FixedSlotCapacity;

    /**
     * Operation getRangeSlotCapacity.
     *
     * @param string $resource_id Resource Identifier. (required)
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\RangeSlotCapacityQuery $body Request body. (required)
     * @param null|string $next_page_token Next page token returned in the response of your previous request. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getRangeSlotCapacity(AccessToken $accessToken, string $region, string $resource_id, array $marketplace_ids, \AmazonPHP\SellingPartner\Model\Services\RangeSlotCapacityQuery $body, ?string $next_page_token = null) : \AmazonPHP\SellingPartner\Model\Services\RangeSlotCapacity;

    /**
     * Operation getServiceJobByServiceJobId.
     *
     * @param string $service_job_id A service job identifier. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id) : \AmazonPHP\SellingPartner\Model\Services\GetServiceJobByServiceJobIdResponse;

    /**
     * Operation getServiceJobs.
     *
     * @param string[] $marketplace_ids Used to select jobs that were placed in the specified marketplaces. (required)
     * @param null|string[] $service_order_ids List of service order ids for the query you want to perform.Max values supported 20. (optional)
     * @param null|string[] $service_job_status A list of one or more job status by which to filter the list of jobs. (optional)
     * @param null|string $page_token String returned in the response of your previous request. (optional)
     * @param null|int $page_size A non-negative integer that indicates the maximum number of jobs to return in the list, Value must be 1 - 20. Default 20. (optional, default to 20)
     * @param null|string $sort_field Sort fields on which you want to sort the output. (optional)
     * @param null|string $sort_order Sort order for the query you want to perform. (optional)
     * @param null|string $created_after A date used for selecting jobs created at or after a specified time. Must be in ISO 8601 format. Required if &#x60;LastUpdatedAfter&#x60; is not specified. Specifying both &#x60;CreatedAfter&#x60; and &#x60;LastUpdatedAfter&#x60; returns an error. (optional)
     * @param null|string $created_before A date used for selecting jobs created at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param null|string $last_updated_after A date used for selecting jobs updated at or after a specified time. Must be in ISO 8601 format. Required if &#x60;createdAfter&#x60; is not specified. Specifying both &#x60;CreatedAfter&#x60; and &#x60;LastUpdatedAfter&#x60; returns an error. (optional)
     * @param null|string $last_updated_before A date used for selecting jobs updated at or before a specified time. Must be in ISO 8601 format. (optional)
     * @param null|string $schedule_start_date A date used for filtering jobs schedules at or after a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param null|string $schedule_end_date A date used for filtering jobs schedules at or before a specified time. Must be in ISO 8601 format. Schedule end date should not be earlier than schedule start date. (optional)
     * @param null|string[] $asins List of Amazon Standard Identification Numbers (ASIN) of the items. Max values supported is 20. (optional)
     * @param null|string[] $required_skills A defined set of related knowledge, skills, experience, tools, materials, and work processes common to service delivery for a set of products and/or service scenarios. Max values supported is 20. (optional)
     * @param null|string[] $store_ids List of Amazon-defined identifiers for the region scope. Max values supported is 50. (optional)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function getServiceJobs(AccessToken $accessToken, string $region, array $marketplace_ids, ?array $service_order_ids = null, ?array $service_job_status = null, ?string $page_token = null, ?int $page_size = 20, ?string $sort_field = null, ?string $sort_order = null, ?string $created_after = null, ?string $created_before = null, ?string $last_updated_after = null, ?string $last_updated_before = null, ?string $schedule_start_date = null, ?string $schedule_end_date = null, ?array $asins = null, ?array $required_skills = null, ?array $store_ids = null) : \AmazonPHP\SellingPartner\Model\Services\GetServiceJobsResponse;

    /**
     * Operation rescheduleAppointmentForServiceJobByServiceJobId.
     *
     * @param string $service_job_id An Amazon defined service job identifier. (required)
     * @param string $appointment_id An existing appointment identifier for the Service Job. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\RescheduleAppointmentRequest $body Reschedule appointment operation input details. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function rescheduleAppointmentForServiceJobByServiceJobId(AccessToken $accessToken, string $region, string $service_job_id, string $appointment_id, \AmazonPHP\SellingPartner\Model\Services\RescheduleAppointmentRequest $body) : \AmazonPHP\SellingPartner\Model\Services\SetAppointmentResponse;

    /**
     * Operation setAppointmentFulfillmentData.
     *
     * @param string $service_job_id An Amazon-defined service job identifier. Get this value by calling the &#x60;getServiceJobs&#x60; operation of the Services API. (required)
     * @param string $appointment_id An Amazon-defined identifier of active service job appointment. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\SetAppointmentFulfillmentDataRequest $body Appointment fulfillment data collection details. (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function setAppointmentFulfillmentData(AccessToken $accessToken, string $region, string $service_job_id, string $appointment_id, \AmazonPHP\SellingPartner\Model\Services\SetAppointmentFulfillmentDataRequest $body) : string;

    /**
     * Operation updateReservation.
     *
     * @param string $reservation_id Reservation Identifier (required)
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\UpdateReservationRequest $body Reservation details (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateReservation(AccessToken $accessToken, string $region, string $reservation_id, array $marketplace_ids, \AmazonPHP\SellingPartner\Model\Services\UpdateReservationRequest $body) : \AmazonPHP\SellingPartner\Model\Services\UpdateReservationResponse;

    /**
     * Operation updateSchedule.
     *
     * @param string $resource_id Resource (store) Identifier (required)
     * @param string[] $marketplace_ids An identifier for the marketplace in which the resource operates. (required)
     * @param \AmazonPHP\SellingPartner\Model\Services\UpdateScheduleRequest $body Schedule details (required)
     *
     * @throws ApiException on non-2xx response
     * @throws InvalidArgumentException
     */
    public function updateSchedule(AccessToken $accessToken, string $region, string $resource_id, array $marketplace_ids, \AmazonPHP\SellingPartner\Model\Services\UpdateScheduleRequest $body) : \AmazonPHP\SellingPartner\Model\Services\UpdateScheduleResponse;
}
