<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Finances\FinancialTransactions;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for Finances.
 *
 * The Selling Partner API for Finances provides financial information relevant to a seller's business. You can obtain financial events for a given order or date range without having to wait until a statement period closes.
 *
 * The version of the OpenAPI document: 2024-06-19
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Context implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'Context';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'store_name' => 'string',
        'order_type' => 'string',
        'channel' => 'string',
        'asin' => 'string',
        'sku' => 'string',
        'quantity_shipped' => 'int',
        'fulfillment_network' => 'string',
        'payment_type' => 'string',
        'payment_method' => 'string',
        'payment_reference' => 'string',
        'payment_date' => '\DateTimeInterface',
        'deferral_reason' => 'string',
        'maturity_date' => '\DateTimeInterface',
        'deferral_status' => 'string',
        'start_time' => '\DateTimeInterface',
        'end_time' => '\DateTimeInterface',
        'context_type' => 'string',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'store_name' => null,
        'order_type' => null,
        'channel' => null,
        'asin' => null,
        'sku' => null,
        'quantity_shipped' => 'int32',
        'fulfillment_network' => null,
        'payment_type' => null,
        'payment_method' => null,
        'payment_reference' => null,
        'payment_date' => 'date-time',
        'deferral_reason' => null,
        'maturity_date' => 'date-time',
        'deferral_status' => null,
        'start_time' => 'date-time',
        'end_time' => 'date-time',
        'context_type' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'store_name' => 'storeName',
        'order_type' => 'orderType',
        'channel' => 'channel',
        'asin' => 'asin',
        'sku' => 'sku',
        'quantity_shipped' => 'quantityShipped',
        'fulfillment_network' => 'fulfillmentNetwork',
        'payment_type' => 'paymentType',
        'payment_method' => 'paymentMethod',
        'payment_reference' => 'paymentReference',
        'payment_date' => 'paymentDate',
        'deferral_reason' => 'deferralReason',
        'maturity_date' => 'maturityDate',
        'deferral_status' => 'deferralStatus',
        'start_time' => 'startTime',
        'end_time' => 'endTime',
        'context_type' => 'contextType',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'store_name' => 'setStoreName',
        'order_type' => 'setOrderType',
        'channel' => 'setChannel',
        'asin' => 'setAsin',
        'sku' => 'setSku',
        'quantity_shipped' => 'setQuantityShipped',
        'fulfillment_network' => 'setFulfillmentNetwork',
        'payment_type' => 'setPaymentType',
        'payment_method' => 'setPaymentMethod',
        'payment_reference' => 'setPaymentReference',
        'payment_date' => 'setPaymentDate',
        'deferral_reason' => 'setDeferralReason',
        'maturity_date' => 'setMaturityDate',
        'deferral_status' => 'setDeferralStatus',
        'start_time' => 'setStartTime',
        'end_time' => 'setEndTime',
        'context_type' => 'setContextType',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'store_name' => 'getStoreName',
        'order_type' => 'getOrderType',
        'channel' => 'getChannel',
        'asin' => 'getAsin',
        'sku' => 'getSku',
        'quantity_shipped' => 'getQuantityShipped',
        'fulfillment_network' => 'getFulfillmentNetwork',
        'payment_type' => 'getPaymentType',
        'payment_method' => 'getPaymentMethod',
        'payment_reference' => 'getPaymentReference',
        'payment_date' => 'getPaymentDate',
        'deferral_reason' => 'getDeferralReason',
        'maturity_date' => 'getMaturityDate',
        'deferral_status' => 'getDeferralStatus',
        'start_time' => 'getStartTime',
        'end_time' => 'getEndTime',
        'context_type' => 'getContextType',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['store_name'] = $data['store_name'] ?? null;
        $this->container['order_type'] = $data['order_type'] ?? null;
        $this->container['channel'] = $data['channel'] ?? null;
        $this->container['asin'] = $data['asin'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['quantity_shipped'] = $data['quantity_shipped'] ?? null;
        $this->container['fulfillment_network'] = $data['fulfillment_network'] ?? null;
        $this->container['payment_type'] = $data['payment_type'] ?? null;
        $this->container['payment_method'] = $data['payment_method'] ?? null;
        $this->container['payment_reference'] = $data['payment_reference'] ?? null;
        $this->container['payment_date'] = $data['payment_date'] ?? null;
        $this->container['deferral_reason'] = $data['deferral_reason'] ?? null;
        $this->container['maturity_date'] = $data['maturity_date'] ?? null;
        $this->container['deferral_status'] = $data['deferral_status'] ?? null;
        $this->container['start_time'] = $data['start_time'] ?? null;
        $this->container['end_time'] = $data['end_time'] ?? null;
        $this->container['context_type'] = $data['context_type'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['context_type'] === null) {
            throw new AssertionException("'context_type' can't be null");
        }
    }

    /**
     * Gets store_name.
     */
    public function getStoreName() : ?string
    {
        return $this->container['store_name'];
    }

    /**
     * Sets store_name.
     *
     * @param null|string $store_name the name of the store that is related to the transaction
     */
    public function setStoreName(?string $store_name) : self
    {
        $this->container['store_name'] = $store_name;

        return $this;
    }

    /**
     * Gets order_type.
     */
    public function getOrderType() : ?string
    {
        return $this->container['order_type'];
    }

    /**
     * Sets order_type.
     *
     * @param null|string $order_type the transaction's order type
     */
    public function setOrderType(?string $order_type) : self
    {
        $this->container['order_type'] = $order_type;

        return $this;
    }

    /**
     * Gets channel.
     */
    public function getChannel() : ?string
    {
        return $this->container['channel'];
    }

    /**
     * Sets channel.
     *
     * @param null|string $channel channel details of related transaction
     */
    public function setChannel(?string $channel) : self
    {
        $this->container['channel'] = $channel;

        return $this;
    }

    /**
     * Gets asin.
     */
    public function getAsin() : ?string
    {
        return $this->container['asin'];
    }

    /**
     * Sets asin.
     *
     * @param null|string $asin the Amazon Standard Identification Number (ASIN) of the item
     */
    public function setAsin(?string $asin) : self
    {
        $this->container['asin'] = $asin;

        return $this;
    }

    /**
     * Gets sku.
     */
    public function getSku() : ?string
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku.
     *
     * @param null|string $sku the Stock Keeping Unit (SKU) of the item
     */
    public function setSku(?string $sku) : self
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets quantity_shipped.
     */
    public function getQuantityShipped() : ?int
    {
        return $this->container['quantity_shipped'];
    }

    /**
     * Sets quantity_shipped.
     *
     * @param null|int $quantity_shipped the quantity of the item shipped
     */
    public function setQuantityShipped(?int $quantity_shipped) : self
    {
        $this->container['quantity_shipped'] = $quantity_shipped;

        return $this;
    }

    /**
     * Gets fulfillment_network.
     */
    public function getFulfillmentNetwork() : ?string
    {
        return $this->container['fulfillment_network'];
    }

    /**
     * Sets fulfillment_network.
     *
     * @param null|string $fulfillment_network the fulfillment network of the item
     */
    public function setFulfillmentNetwork(?string $fulfillment_network) : self
    {
        $this->container['fulfillment_network'] = $fulfillment_network;

        return $this;
    }

    /**
     * Gets payment_type.
     */
    public function getPaymentType() : ?string
    {
        return $this->container['payment_type'];
    }

    /**
     * Sets payment_type.
     *
     * @param null|string $payment_type the type of payment
     */
    public function setPaymentType(?string $payment_type) : self
    {
        $this->container['payment_type'] = $payment_type;

        return $this;
    }

    /**
     * Gets payment_method.
     */
    public function getPaymentMethod() : ?string
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method.
     *
     * @param null|string $payment_method the method of payment
     */
    public function setPaymentMethod(?string $payment_method) : self
    {
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets payment_reference.
     */
    public function getPaymentReference() : ?string
    {
        return $this->container['payment_reference'];
    }

    /**
     * Sets payment_reference.
     *
     * @param null|string $payment_reference the reference number of the payment
     */
    public function setPaymentReference(?string $payment_reference) : self
    {
        $this->container['payment_reference'] = $payment_reference;

        return $this;
    }

    /**
     * Gets payment_date.
     */
    public function getPaymentDate() : ?\DateTimeInterface
    {
        return $this->container['payment_date'];
    }

    /**
     * Sets payment_date.
     *
     * @param null|\DateTimeInterface $payment_date A date in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.
     */
    public function setPaymentDate(?\DateTimeInterface $payment_date) : self
    {
        $this->container['payment_date'] = $payment_date;

        return $this;
    }

    /**
     * Gets deferral_reason.
     */
    public function getDeferralReason() : ?string
    {
        return $this->container['deferral_reason'];
    }

    /**
     * Sets deferral_reason.
     *
     * @param null|string $deferral_reason Deferral policy applied on the transaction.  **Examples:** `B2B`,`DD7`
     */
    public function setDeferralReason(?string $deferral_reason) : self
    {
        $this->container['deferral_reason'] = $deferral_reason;

        return $this;
    }

    /**
     * Gets maturity_date.
     */
    public function getMaturityDate() : ?\DateTimeInterface
    {
        return $this->container['maturity_date'];
    }

    /**
     * Sets maturity_date.
     *
     * @param null|\DateTimeInterface $maturity_date A date in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.
     */
    public function setMaturityDate(?\DateTimeInterface $maturity_date) : self
    {
        $this->container['maturity_date'] = $maturity_date;

        return $this;
    }

    /**
     * Gets deferral_status.
     */
    public function getDeferralStatus() : ?string
    {
        return $this->container['deferral_status'];
    }

    /**
     * Sets deferral_status.
     *
     * @param null|string $deferral_status The status of the transaction. For example, `HOLD`,`RELEASE`.
     */
    public function setDeferralStatus(?string $deferral_status) : self
    {
        $this->container['deferral_status'] = $deferral_status;

        return $this;
    }

    /**
     * Gets start_time.
     */
    public function getStartTime() : ?\DateTimeInterface
    {
        return $this->container['start_time'];
    }

    /**
     * Sets start_time.
     *
     * @param null|\DateTimeInterface $start_time A date in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.
     */
    public function setStartTime(?\DateTimeInterface $start_time) : self
    {
        $this->container['start_time'] = $start_time;

        return $this;
    }

    /**
     * Gets end_time.
     */
    public function getEndTime() : ?\DateTimeInterface
    {
        return $this->container['end_time'];
    }

    /**
     * Sets end_time.
     *
     * @param null|\DateTimeInterface $end_time A date in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.
     */
    public function setEndTime(?\DateTimeInterface $end_time) : self
    {
        $this->container['end_time'] = $end_time;

        return $this;
    }

    /**
     * Gets context_type.
     */
    public function getContextType() : string
    {
        return $this->container['context_type'];
    }

    /**
     * Sets context_type.
     *
     * @param string $context_type context_type
     */
    public function setContextType(string $context_type) : self
    {
        $this->container['context_type'] = $context_type;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
