<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class CreateMarketplaceItemLabelsRequest implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'CreateMarketplaceItemLabelsRequest';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'height' => 'float',
        'label_type' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\LabelPrintType',
        'locale_code' => 'string',
        'marketplace_id' => 'string',
        'msku_quantities' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\MskuQuantity[]',
        'page_type' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\ItemLabelPageType',
        'width' => 'float',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'height' => null,
        'label_type' => null,
        'locale_code' => null,
        'marketplace_id' => null,
        'msku_quantities' => null,
        'page_type' => null,
        'width' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'height' => 'height',
        'label_type' => 'labelType',
        'locale_code' => 'localeCode',
        'marketplace_id' => 'marketplaceId',
        'msku_quantities' => 'mskuQuantities',
        'page_type' => 'pageType',
        'width' => 'width',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'height' => 'setHeight',
        'label_type' => 'setLabelType',
        'locale_code' => 'setLocaleCode',
        'marketplace_id' => 'setMarketplaceId',
        'msku_quantities' => 'setMskuQuantities',
        'page_type' => 'setPageType',
        'width' => 'setWidth',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'height' => 'getHeight',
        'label_type' => 'getLabelType',
        'locale_code' => 'getLocaleCode',
        'marketplace_id' => 'getMarketplaceId',
        'msku_quantities' => 'getMskuQuantities',
        'page_type' => 'getPageType',
        'width' => 'getWidth',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['height'] = $data['height'] ?? null;
        $this->container['label_type'] = $data['label_type'] ?? null;
        $this->container['locale_code'] = $data['locale_code'] ?? 'en_US';
        $this->container['marketplace_id'] = $data['marketplace_id'] ?? null;
        $this->container['msku_quantities'] = $data['msku_quantities'] ?? null;
        $this->container['page_type'] = $data['page_type'] ?? null;
        $this->container['width'] = $data['width'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if (null !== $this->container['height'] && ($this->container['height'] > 1E+2)) {
            throw new AssertionException("invalid value for 'height', must be smaller than or equal to 1E+2.");
        }

        if (null !== $this->container['height'] && ($this->container['height'] < 25)) {
            throw new AssertionException("invalid value for 'height', must be bigger than or equal to 25.");
        }

        if ($this->container['label_type'] === null) {
            throw new AssertionException("'label_type' can't be null");
        }

        if (null !== $this->container['locale_code'] && !\preg_match('/^[a-z]{2}_[A-Z]{2}$/', (string) $this->container['locale_code'])) {
            throw new AssertionException("invalid value for 'locale_code', must be conform to the pattern /^[a-z]{2}_[A-Z]{2}$/.");
        }

        if ($this->container['marketplace_id'] === null) {
            throw new AssertionException("'marketplace_id' can't be null");
        }

        if ((\mb_strlen((string) $this->container['marketplace_id']) > 20)) {
            throw new AssertionException("invalid value for 'marketplace_id', the character length must be smaller than or equal to 20.");
        }

        if ((\mb_strlen((string) $this->container['marketplace_id']) < 1)) {
            throw new AssertionException("invalid value for 'marketplace_id', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['msku_quantities'] === null) {
            throw new AssertionException("'msku_quantities' can't be null");
        }

        if ((\count($this->container['msku_quantities']) > 100)) {
            throw new AssertionException("invalid value for 'msku_quantities', number of items must be less than or equal to 100.");
        }

        if ((\count($this->container['msku_quantities']) < 1)) {
            throw new AssertionException("invalid value for 'msku_quantities', number of items must be greater than or equal to 1.");
        }

        if (null !== $this->container['width'] && ($this->container['width'] > 1E+2)) {
            throw new AssertionException("invalid value for 'width', must be smaller than or equal to 1E+2.");
        }

        if (null !== $this->container['width'] && ($this->container['width'] < 25)) {
            throw new AssertionException("invalid value for 'width', must be bigger than or equal to 25.");
        }
    }

    /**
     * Gets height.
     */
    public function getHeight() : ?float
    {
        return $this->container['height'];
    }

    /**
     * Sets height.
     *
     * @param null|float $height the height of the item label
     */
    public function setHeight(?float $height) : self
    {
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets label_type.
     */
    public function getLabelType() : LabelPrintType
    {
        return $this->container['label_type'];
    }

    /**
     * Sets label_type.
     *
     * @param LabelPrintType $label_type label_type
     */
    public function setLabelType(LabelPrintType $label_type) : self
    {
        $this->container['label_type'] = $label_type;

        return $this;
    }

    /**
     * Gets locale_code.
     */
    public function getLocaleCode() : ?string
    {
        return $this->container['locale_code'];
    }

    /**
     * Sets locale_code.
     *
     * @param null|string $locale_code the locale code constructed from ISO 639 language code and ISO 3166-1 alpha-2 standard of country codes separated by an underscore character
     */
    public function setLocaleCode(?string $locale_code) : self
    {
        $this->container['locale_code'] = $locale_code;

        return $this;
    }

    /**
     * Gets marketplace_id.
     */
    public function getMarketplaceId() : string
    {
        return $this->container['marketplace_id'];
    }

    /**
     * Sets marketplace_id.
     *
     * @param string $marketplace_id The Marketplace ID. For a list of possible values, refer to [Marketplace IDs](https://developer-docs.amazon.com/sp-api/docs/marketplace-ids).
     */
    public function setMarketplaceId(string $marketplace_id) : self
    {
        $this->container['marketplace_id'] = $marketplace_id;

        return $this;
    }

    /**
     * Gets msku_quantities.
     *
     * @return MskuQuantity[]
     */
    public function getMskuQuantities() : array
    {
        return $this->container['msku_quantities'];
    }

    /**
     * Sets msku_quantities.
     *
     * @param MskuQuantity[] $msku_quantities represents the quantity of an MSKU to print item labels for
     */
    public function setMskuQuantities(array $msku_quantities) : self
    {
        $this->container['msku_quantities'] = $msku_quantities;

        return $this;
    }

    /**
     * Gets page_type.
     */
    public function getPageType() : ?ItemLabelPageType
    {
        return $this->container['page_type'];
    }

    /**
     * Sets page_type.
     *
     * @param null|ItemLabelPageType $page_type page_type
     */
    public function setPageType(?ItemLabelPageType $page_type) : self
    {
        $this->container['page_type'] = $page_type;

        return $this;
    }

    /**
     * Gets width.
     */
    public function getWidth() : ?float
    {
        return $this->container['width'];
    }

    /**
     * Sets width.
     *
     * @param null|float $width the width of the item label
     */
    public function setWidth(?float $width) : self
    {
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
