<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInbound;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * The Selling Partner API for FBA inbound operations.
 *
 * The Selling Partner API for Fulfillment By Amazon (FBA) Inbound. The FBA Inbound API enables building inbound workflows to create, manage, and send shipments into Amazon's fulfillment network. The API has interoperability with the Send-to-Amazon user interface.
 *
 * The version of the OpenAPI document: 2024-03-20
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class MskuPrepDetailInput implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'MskuPrepDetailInput';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'msku' => 'string',
        'prep_category' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\PrepCategory',
        'prep_types' => '\AmazonPHP\SellingPartner\Model\FulfillmentInbound\PrepType[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'msku' => null,
        'prep_category' => null,
        'prep_types' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'msku' => 'msku',
        'prep_category' => 'prepCategory',
        'prep_types' => 'prepTypes',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'msku' => 'setMsku',
        'prep_category' => 'setPrepCategory',
        'prep_types' => 'setPrepTypes',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'msku' => 'getMsku',
        'prep_category' => 'getPrepCategory',
        'prep_types' => 'getPrepTypes',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['msku'] = $data['msku'] ?? null;
        $this->container['prep_category'] = $data['prep_category'] ?? null;
        $this->container['prep_types'] = $data['prep_types'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['msku'] === null) {
            throw new AssertionException("'msku' can't be null");
        }

        if ((\mb_strlen((string) $this->container['msku']) > 40)) {
            throw new AssertionException("invalid value for 'msku', the character length must be smaller than or equal to 40.");
        }

        if ((\mb_strlen((string) $this->container['msku']) < 1)) {
            throw new AssertionException("invalid value for 'msku', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['prep_category'] === null) {
            throw new AssertionException("'prep_category' can't be null");
        }

        if ($this->container['prep_types'] === null) {
            throw new AssertionException("'prep_types' can't be null");
        }
    }

    /**
     * Gets msku.
     */
    public function getMsku() : string
    {
        return $this->container['msku'];
    }

    /**
     * Sets msku.
     *
     * @param string $msku the merchant SKU, a merchant-supplied identifier for a specific SKU
     */
    public function setMsku(string $msku) : self
    {
        $this->container['msku'] = $msku;

        return $this;
    }

    /**
     * Gets prep_category.
     */
    public function getPrepCategory() : PrepCategory
    {
        return $this->container['prep_category'];
    }

    /**
     * Sets prep_category.
     *
     * @param PrepCategory $prep_category prep_category
     */
    public function setPrepCategory(PrepCategory $prep_category) : self
    {
        $this->container['prep_category'] = $prep_category;

        return $this;
    }

    /**
     * Gets prep_types.
     *
     * @return PrepType[]
     */
    public function getPrepTypes() : array
    {
        return $this->container['prep_types'];
    }

    /**
     * Sets prep_types.
     *
     * @param PrepType[] $prep_types a list of preparation types associated with a preparation category
     */
    public function setPrepTypes(array $prep_types) : self
    {
        $this->container['prep_types'] = $prep_types;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
