<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\FulfillmentInboundV0;

/**
 * Selling Partner API for Fulfillment Inbound.
 *
 * The Selling Partner API for Fulfillment Inbound lets you create applications that create and update inbound shipments of inventory to Amazon's fulfillment network.
 *
 * The version of the OpenAPI document: v0
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 */
class ShipmentStatus
{
    /**
     * Possible values of this enum.
     */
    final public const WORKING = 'WORKING';

    final public const SHIPPED = 'SHIPPED';

    final public const RECEIVING = 'RECEIVING';

    final public const CANCELLED = 'CANCELLED';

    final public const DELETED = 'DELETED';

    final public const CLOSED = 'CLOSED';

    final public const ERROR = 'ERROR';

    final public const IN_TRANSIT = 'IN_TRANSIT';

    final public const DELIVERED = 'DELIVERED';

    final public const CHECKED_IN = 'CHECKED_IN';

    public function __construct(private readonly string $value)
    {
    }

    /**
     * Gets allowable values of the enum.
     *
     * @return string[]
     */
    public static function getAllowableEnumValues() : array
    {
        return [
            self::WORKING,
            self::SHIPPED,
            self::RECEIVING,
            self::CANCELLED,
            self::DELETED,
            self::CLOSED,
            self::ERROR,
            self::IN_TRANSIT,
            self::DELIVERED,
            self::CHECKED_IN,
        ];
    }

    public function toString() : string
    {
        return $this->value;
    }
}
