<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\Shipping;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Shipping.
 *
 * Provides programmatic access to Amazon Shipping APIs.   **Note:** If you are new to the Amazon Shipping API, refer to the latest version of <a href=\"https://developer-docs.amazon.com/amazon-shipping/docs/shipping-api-v2-reference\">Amazon Shipping API (v2)</a> on the <a href=\"https://developer-docs.amazon.com/amazon-shipping/\">Amazon Shipping Developer Documentation</a> site.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TrackingInformation implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'TrackingInformation';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'tracking_id' => 'string',
        'summary' => '\AmazonPHP\SellingPartner\Model\Shipping\TrackingSummary',
        'promised_delivery_date' => '\DateTimeInterface',
        'event_history' => '\AmazonPHP\SellingPartner\Model\Shipping\Event[]',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'tracking_id' => null,
        'summary' => null,
        'promised_delivery_date' => 'date-time',
        'event_history' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'tracking_id' => 'trackingId',
        'summary' => 'summary',
        'promised_delivery_date' => 'promisedDeliveryDate',
        'event_history' => 'eventHistory',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'tracking_id' => 'setTrackingId',
        'summary' => 'setSummary',
        'promised_delivery_date' => 'setPromisedDeliveryDate',
        'event_history' => 'setEventHistory',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'tracking_id' => 'getTrackingId',
        'summary' => 'getSummary',
        'promised_delivery_date' => 'getPromisedDeliveryDate',
        'event_history' => 'getEventHistory',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['tracking_id'] = $data['tracking_id'] ?? null;
        $this->container['summary'] = $data['summary'] ?? null;
        $this->container['promised_delivery_date'] = $data['promised_delivery_date'] ?? null;
        $this->container['event_history'] = $data['event_history'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['tracking_id'] === null) {
            throw new AssertionException("'tracking_id' can't be null");
        }

        if ((\mb_strlen((string) $this->container['tracking_id']) > 60)) {
            throw new AssertionException("invalid value for 'tracking_id', the character length must be smaller than or equal to 60.");
        }

        if ((\mb_strlen((string) $this->container['tracking_id']) < 1)) {
            throw new AssertionException("invalid value for 'tracking_id', the character length must be bigger than or equal to 1.");
        }

        if ($this->container['summary'] === null) {
            throw new AssertionException("'summary' can't be null");
        }

        $this->container['summary']->validate();

        if ($this->container['promised_delivery_date'] === null) {
            throw new AssertionException("'promised_delivery_date' can't be null");
        }

        if ($this->container['event_history'] === null) {
            throw new AssertionException("'event_history' can't be null");
        }
    }

    /**
     * Gets tracking_id.
     */
    public function getTrackingId() : string
    {
        return $this->container['tracking_id'];
    }

    /**
     * Sets tracking_id.
     *
     * @param string $tracking_id The tracking id generated to each shipment. It contains a series of letters or digits or both.
     */
    public function setTrackingId(string $tracking_id) : self
    {
        $this->container['tracking_id'] = $tracking_id;

        return $this;
    }

    /**
     * Gets summary.
     */
    public function getSummary() : TrackingSummary
    {
        return $this->container['summary'];
    }

    /**
     * Sets summary.
     *
     * @param TrackingSummary $summary summary
     */
    public function setSummary(TrackingSummary $summary) : self
    {
        $this->container['summary'] = $summary;

        return $this;
    }

    /**
     * Gets promised_delivery_date.
     */
    public function getPromisedDeliveryDate() : \DateTimeInterface
    {
        return $this->container['promised_delivery_date'];
    }

    /**
     * Sets promised_delivery_date.
     *
     * @param \DateTimeInterface $promised_delivery_date the promised delivery date and time of a shipment
     */
    public function setPromisedDeliveryDate(\DateTimeInterface $promised_delivery_date) : self
    {
        $this->container['promised_delivery_date'] = $promised_delivery_date;

        return $this;
    }

    /**
     * Gets event_history.
     *
     * @return Event[]
     */
    public function getEventHistory() : array
    {
        return $this->container['event_history'];
    }

    /**
     * Sets event_history.
     *
     * @param Event[] $event_history a list of events of a shipment
     */
    public function setEventHistory(array $event_history) : self
    {
        $this->container['event_history'] = $event_history;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
