<?php

declare(strict_types=1);

namespace AmazonPHP\SellingPartner\Model\VendorShipments;

use AmazonPHP\SellingPartner\Exception\AssertionException;
use AmazonPHP\SellingPartner\ModelInterface;
use AmazonPHP\SellingPartner\ObjectSerializer;

/**
 * Selling Partner API for Retail Procurement Shipments.
 *
 * The Selling Partner API for Retail Procurement Shipments provides programmatic access to retail shipping data for vendors.
 *
 * The version of the OpenAPI document: v1
 *
 * This class was auto-generated by https://openapi-generator.tech
 * Do not change it, it will be overwritten with next execution of /bin/generate.sh
 *
 * @implements \ArrayAccess<TKey, TValue>
 *
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ContainerItem implements \ArrayAccess, \JsonSerializable, \Stringable, ModelInterface
{
    final public const DISCRIMINATOR = null;

    /**
     * The original name of the model.
     */
    protected static string $openAPIModelName = 'ContainerItem';

    /**
     * Array of property to type mappings. Used for (de)serialization.
     *
     * @var string[]
     */
    protected static array $openAPITypes = [
        'item_reference' => 'string',
        'shipped_quantity' => '\AmazonPHP\SellingPartner\Model\VendorShipments\ItemQuantity',
        'item_details' => '\AmazonPHP\SellingPartner\Model\VendorShipments\ItemDetails',
    ];

    /**
     * Array of property to format mappings. Used for (de)serialization.
     *
     * @var string[]
     *
     * @phpstan-var array<string, string|null>
     *
     * @psalm-var array<string, string|null>
     */
    protected static array $openAPIFormats = [
        'item_reference' => null,
        'shipped_quantity' => null,
        'item_details' => null,
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     *
     * @var string[]
     */
    protected static array $attributeMap = [
        'item_reference' => 'itemReference',
        'shipped_quantity' => 'shippedQuantity',
        'item_details' => 'itemDetails',
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     *
     * @var string[]
     */
    protected static array $setters = [
        'item_reference' => 'setItemReference',
        'shipped_quantity' => 'setShippedQuantity',
        'item_details' => 'setItemDetails',
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests).
     *
     * @var string[]
     */
    protected static array $getters = [
        'item_reference' => 'getItemReference',
        'shipped_quantity' => 'getShippedQuantity',
        'item_details' => 'getItemDetails',
    ];

    /**
     * Associative array for storing property values.
     *
     * @var mixed[]
     */
    protected array $container = [];

    /**
     * Constructor.
     *
     * @param null|mixed[] $data Associated array of property values
     *                           initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['item_reference'] = $data['item_reference'] ?? null;
        $this->container['shipped_quantity'] = $data['shipped_quantity'] ?? null;
        $this->container['item_details'] = $data['item_details'] ?? null;
    }

    /**
     * Array of property to type mappings. Used for (de)serialization.
     */
    public static function openAPITypes() : array
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization.
     */
    public static function openAPIFormats() : array
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name.
     */
    public static function attributeMap() : array
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses).
     */
    public static function setters() : array
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests).
     */
    public static function getters() : array
    {
        return self::$getters;
    }

    /**
     * Gets the string presentation of the object.
     */
    public function __toString() : string
    {
        return (string) \json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * The original name of the model.
     */
    public function getModelName() : string
    {
        return self::$openAPIModelName;
    }

    /**
     * Validate all properties.
     *
     * @throws AssertionException
     */
    public function validate() : void
    {
        if ($this->container['item_reference'] === null) {
            throw new AssertionException("'item_reference' can't be null");
        }

        if ($this->container['shipped_quantity'] === null) {
            throw new AssertionException("'shipped_quantity' can't be null");
        }

        $this->container['shipped_quantity']->validate();

        if ($this->container['item_details'] !== null) {
            $this->container['item_details']->validate();
        }
    }

    /**
     * Gets item_reference.
     */
    public function getItemReference() : string
    {
        return $this->container['item_reference'];
    }

    /**
     * Sets item_reference.
     *
     * @param string $item_reference The reference number for the item. Please provide the itemSequenceNumber from the 'items' segment to refer to that item's details here.
     */
    public function setItemReference(string $item_reference) : self
    {
        $this->container['item_reference'] = $item_reference;

        return $this;
    }

    /**
     * Gets shipped_quantity.
     */
    public function getShippedQuantity() : ItemQuantity
    {
        return $this->container['shipped_quantity'];
    }

    /**
     * Sets shipped_quantity.
     *
     * @param ItemQuantity $shipped_quantity shipped_quantity
     */
    public function setShippedQuantity(ItemQuantity $shipped_quantity) : self
    {
        $this->container['shipped_quantity'] = $shipped_quantity;

        return $this;
    }

    /**
     * Gets item_details.
     */
    public function getItemDetails() : ?ItemDetails
    {
        return $this->container['item_details'];
    }

    /**
     * Sets item_details.
     *
     * @param null|ItemDetails $item_details item_details
     */
    public function setItemDetails(?ItemDetails $item_details) : self
    {
        $this->container['item_details'] = $item_details;

        return $this;
    }

    /**
     * Returns true if offset exists. False otherwise.
     */
    public function offsetExists($offset) : bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @return null|mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset) : mixed
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     */
    public function offsetSet($offset, $value) : void
    {
        if (null === $offset) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     */
    public function offsetUnset($offset) : void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     *
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed returns data which can be serialized by json_encode(), which is a value
     *               of any type other than a resource
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }

    /**
     * Gets a header-safe presentation of the object.
     */
    public function toHeaderValue() : string
    {
        return \json_encode(ObjectSerializer::sanitizeForSerialization($this), JSON_THROW_ON_ERROR);
    }
}
